package com.finconsgroup.itserr.marketplace.event.bs.enums;


import com.finconsgroup.itserr.marketplace.event.bs.controller.DiagnosticsController;

/**
 * Enumeration representing resource lifecycle events for debugging and analysis purposes.
 * <p>
 * <b>Note:</b> This enum is intended solely for diagnostic use and should not be used
 * in production business logic.
 *
 * <p>Supported event types:</p>
 * <ul>
 *   <li>{@code CREATED} - Indicates a new resource was created</li>
 *   <li>{@code UPDATED} - Indicates an existing resource was modified</li>
 *   <li>{@code DELETED} - Indicates a resource was removed</li>
 *   <li>{@code REGISTER} - Indicates a user has registered to an event</li>
 *   <li>{@code UNREGISTER} - Indicates a  user has unregistered to an event</li>
 * </ul>
 *
 * @see DiagnosticsController#publishMessage(MessagingEventType, String)
 * @since 1.0
 */
public enum MessagingEventType {
    CREATED,
    UPDATED,
    DELETED,
    REGISTER,
    UNREGISTER
}
