/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.dto;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputImageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputScheduleDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="InputCreateEventDto", description="DTO for creating event")
public class InputCreateEventDto {
    @Schema(description="The title of the event", example="Annual Tech Conference 2025")
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String title;
    @Schema(description="The link for the event", example="https://meeting.example.com/test123")
    @Size(max=255)
    private @Size(max=255) String eventLink;
    @Schema(description="The type of event", example="webinar")
    @Size(max=50)
    private @Size(max=50) String eventType;
    @Schema(description="The content of the event", example="Join us for the biggest tech conference of the year...")
    @Size(max=800)
    private @Size(max=800) String content;
    @Schema(description="The maximum number of participants allowed for the event", example="22")
    private Integer maxParticipants;
    @Schema(description="List of tags associated with the event", example="[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;
    @Schema(description="List of institutional pages")
    private List<InputInstitutionalPageDto> institutionalPages;
    @Schema(description="The image for the event")
    @Valid
    private InputImageDto image;
    @Schema(description="The timezone for the event", example="Europe/Rome")
    @NotBlank
    private String timezone;
    @Schema(description="The event conductors")
    @Valid
    @NotEmpty
    private List<InputEventConductorDto> eventConductors;
    @Schema(description="The event schedules")
    @Valid
    @NotEmpty
    private List<InputScheduleDto> schedules;

    @Generated
    protected InputCreateEventDto(InputCreateEventDtoBuilder<?, ?> b) {
        this.title = b.title;
        this.eventLink = b.eventLink;
        this.eventType = b.eventType;
        this.content = b.content;
        this.maxParticipants = b.maxParticipants;
        this.tags = b.tags;
        this.institutionalPages = b.institutionalPages;
        this.image = b.image;
        this.timezone = b.timezone;
        this.eventConductors = b.eventConductors;
        this.schedules = b.schedules;
    }

    @Generated
    public static InputCreateEventDtoBuilder<?, ?> builder() {
        return new InputCreateEventDtoBuilderImpl();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getEventLink() {
        return this.eventLink;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<InputInstitutionalPageDto> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public InputImageDto getImage() {
        return this.image;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public List<InputEventConductorDto> getEventConductors() {
        return this.eventConductors;
    }

    @Generated
    public List<InputScheduleDto> getSchedules() {
        return this.schedules;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setEventLink(String eventLink) {
        this.eventLink = eventLink;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<InputInstitutionalPageDto> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImage(InputImageDto image) {
        this.image = image;
    }

    @Generated
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Generated
    public void setEventConductors(List<InputEventConductorDto> eventConductors) {
        this.eventConductors = eventConductors;
    }

    @Generated
    public void setSchedules(List<InputScheduleDto> schedules) {
        this.schedules = schedules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateEventDto)) {
            return false;
        }
        InputCreateEventDto other = (InputCreateEventDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxParticipants = this.getMaxParticipants();
        Integer other$maxParticipants = other.getMaxParticipants();
        if (this$maxParticipants == null ? other$maxParticipants != null : !((Object)this$maxParticipants).equals(other$maxParticipants)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$eventLink = this.getEventLink();
        String other$eventLink = other.getEventLink();
        if (this$eventLink == null ? other$eventLink != null : !this$eventLink.equals(other$eventLink)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<InputInstitutionalPageDto> this$institutionalPages = this.getInstitutionalPages();
        List<InputInstitutionalPageDto> other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        InputImageDto this$image = this.getImage();
        InputImageDto other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        List<InputEventConductorDto> this$eventConductors = this.getEventConductors();
        List<InputEventConductorDto> other$eventConductors = other.getEventConductors();
        if (this$eventConductors == null ? other$eventConductors != null : !((Object)this$eventConductors).equals(other$eventConductors)) {
            return false;
        }
        List<InputScheduleDto> this$schedules = this.getSchedules();
        List<InputScheduleDto> other$schedules = other.getSchedules();
        return !(this$schedules == null ? other$schedules != null : !((Object)this$schedules).equals(other$schedules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateEventDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxParticipants = this.getMaxParticipants();
        result = result * 59 + ($maxParticipants == null ? 43 : ((Object)$maxParticipants).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $eventLink = this.getEventLink();
        result = result * 59 + ($eventLink == null ? 43 : $eventLink.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<InputInstitutionalPageDto> $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        InputImageDto $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        List<InputEventConductorDto> $eventConductors = this.getEventConductors();
        result = result * 59 + ($eventConductors == null ? 43 : ((Object)$eventConductors).hashCode());
        List<InputScheduleDto> $schedules = this.getSchedules();
        result = result * 59 + ($schedules == null ? 43 : ((Object)$schedules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateEventDto(title=" + this.getTitle() + ", eventLink=" + this.getEventLink() + ", eventType=" + this.getEventType() + ", content=" + this.getContent() + ", maxParticipants=" + this.getMaxParticipants() + ", tags=" + String.valueOf(this.getTags()) + ", institutionalPages=" + String.valueOf(this.getInstitutionalPages()) + ", image=" + String.valueOf(this.getImage()) + ", timezone=" + this.getTimezone() + ", eventConductors=" + String.valueOf(this.getEventConductors()) + ", schedules=" + String.valueOf(this.getSchedules()) + ")";
    }

    @Generated
    public InputCreateEventDto() {
    }

    @Generated
    public InputCreateEventDto(String title, String eventLink, String eventType, String content, Integer maxParticipants, List<String> tags, List<InputInstitutionalPageDto> institutionalPages, InputImageDto image, String timezone, List<InputEventConductorDto> eventConductors, List<InputScheduleDto> schedules) {
        this.title = title;
        this.eventLink = eventLink;
        this.eventType = eventType;
        this.content = content;
        this.maxParticipants = maxParticipants;
        this.tags = tags;
        this.institutionalPages = institutionalPages;
        this.image = image;
        this.timezone = timezone;
        this.eventConductors = eventConductors;
        this.schedules = schedules;
    }

    @Generated
    public static abstract class InputCreateEventDtoBuilder<C extends InputCreateEventDto, B extends InputCreateEventDtoBuilder<C, B>> {
        @Generated
        private String title;
        @Generated
        private String eventLink;
        @Generated
        private String eventType;
        @Generated
        private String content;
        @Generated
        private Integer maxParticipants;
        @Generated
        private List<String> tags;
        @Generated
        private List<InputInstitutionalPageDto> institutionalPages;
        @Generated
        private InputImageDto image;
        @Generated
        private String timezone;
        @Generated
        private List<InputEventConductorDto> eventConductors;
        @Generated
        private List<InputScheduleDto> schedules;

        @Generated
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @Generated
        public B eventLink(String eventLink) {
            this.eventLink = eventLink;
            return this.self();
        }

        @Generated
        public B eventType(String eventType) {
            this.eventType = eventType;
            return this.self();
        }

        @Generated
        public B content(String content) {
            this.content = content;
            return this.self();
        }

        @Generated
        public B maxParticipants(Integer maxParticipants) {
            this.maxParticipants = maxParticipants;
            return this.self();
        }

        @Generated
        public B tags(List<String> tags) {
            this.tags = tags;
            return this.self();
        }

        @Generated
        public B institutionalPages(List<InputInstitutionalPageDto> institutionalPages) {
            this.institutionalPages = institutionalPages;
            return this.self();
        }

        @Generated
        public B image(InputImageDto image) {
            this.image = image;
            return this.self();
        }

        @Generated
        public B timezone(String timezone) {
            this.timezone = timezone;
            return this.self();
        }

        @Generated
        public B eventConductors(List<InputEventConductorDto> eventConductors) {
            this.eventConductors = eventConductors;
            return this.self();
        }

        @Generated
        public B schedules(List<InputScheduleDto> schedules) {
            this.schedules = schedules;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputCreateEventDto.InputCreateEventDtoBuilder(title=" + this.title + ", eventLink=" + this.eventLink + ", eventType=" + this.eventType + ", content=" + this.content + ", maxParticipants=" + this.maxParticipants + ", tags=" + String.valueOf(this.tags) + ", institutionalPages=" + String.valueOf(this.institutionalPages) + ", image=" + String.valueOf(this.image) + ", timezone=" + this.timezone + ", eventConductors=" + String.valueOf(this.eventConductors) + ", schedules=" + String.valueOf(this.schedules) + ")";
        }
    }

    @Generated
    private static final class InputCreateEventDtoBuilderImpl
    extends InputCreateEventDtoBuilder<InputCreateEventDto, InputCreateEventDtoBuilderImpl> {
        @Generated
        private InputCreateEventDtoBuilderImpl() {
        }

        @Override
        @Generated
        protected InputCreateEventDtoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputCreateEventDto build() {
            return new InputCreateEventDto(this);
        }
    }
}

