package com.finconsgroup.itserr.marketplace.event.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO for schedule of an event.
 */
@Schema(name = "OutputScheduleDto", description = "DTO for schedule")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputScheduleDto {

    @JsonIgnore
    @Hidden
    private UUID id;

    @Schema(description = "The title of the schedule", example = "Day 1")
    private String title;

    @Schema(description = "The description of the schedule", example = "Day 1 of Annual Tech Conference 2025")
    private String description;

    @Schema(description = "The start date of the schedule", example = "2025-06-18")
    private LocalDate startDate;

    @Schema(description = "The start time of the schedule", example = "10:30:00")
    private LocalTime startTime;

    @Schema(description = "The end time of the schedule", example = "15:30:00")
    private LocalTime endTime;

    @Schema(description = "The location of the schedule")
    private OutputLocationDto location;

    @Schema(description = "The programs of the schedule")
    private List<OutputProgramDto> programs;
}
