/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.validation.annotation.ValidAssociationToLoad;
import com.finconsgroup.itserr.marketplace.event.dm.validation.annotation.ValidInputCreateOrUpdateEventDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="EventApi", description="The EventApi API: it provides endpoints for retrieving, creating, updating, and deleting event.")
@SecurityRequirement(name="BearerAuth")
public interface EventApi {
    @Operation(summary="find all the event", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/event/events"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputEventDto> findAll(@RequestParam(name="associationsToLoad", defaultValue="", required=false) Set<@ValidAssociationToLoad String> var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="startDate", required=false) String var4, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var5);

    @Operation(summary="find event by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/event/events/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputEventDto findById(@PathVariable(value="id") UUID var1);

    @Operation(summary="create a event", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/event/events"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputEventDto createEvent(@Valid @ValidInputCreateOrUpdateEventDto @RequestBody InputCreateEventDto var1);

    @Operation(summary="updates event by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PutMapping(value={"/event/events/{id}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputEventDto updateEventById(@PathVariable(value="id") UUID var1, @Valid @ValidInputCreateOrUpdateEventDto @RequestBody InputUpdateEventDto var2);

    @Operation(summary="delete a event by id", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/event/events/{id}"})
    public void deleteEventById(@PathVariable(value="id") UUID var1);
}

