/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.event.dm.api.EventApi;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.service.EventService;
import java.beans.PropertyEditor;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventController
implements EventApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventController.class);
    private final EventService eventService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    public Page<OutputEventDto> findAll(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.eventService.findAll(associationsToLoad, (Pageable)pageable);
    }

    public OutputEventDto findById(UUID eventId) {
        return this.eventService.findById(eventId);
    }

    public OutputEventDto createEvent(InputCreateEventDto inputCreateEventDto) {
        return this.eventService.create(JwtTokenHolder.getUserIdOrThrow(), inputCreateEventDto);
    }

    public OutputEventDto updateEventById(UUID eventId, InputUpdateEventDto inputUpdateEventDto) {
        return this.eventService.updateById(JwtTokenHolder.getUserIdOrThrow(), eventId, inputUpdateEventDto);
    }

    public void deleteEventById(UUID eventId) {
        this.eventService.deleteById(JwtTokenHolder.getUserIdOrThrow(), eventId);
    }

    @Generated
    public EventController(EventService eventService) {
        this.eventService = eventService;
    }
}

