/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="schedule")
public class ScheduleEntity
extends AbstractUUIDEntity {
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="event_id", updatable=false)
    private EventEntity event;
    @Column(name="event_id", insertable=false, updatable=false)
    private UUID eventId;
    @Column(name="description", length=255)
    private String description;
    @Column(name="start_date", nullable=false)
    private LocalDate startDate;
    @Column(name="start_time", nullable=false)
    private LocalTime startTime;
    @Column(name="end_time", nullable=false)
    private LocalTime endTime;
    @Column(name="location_city")
    private String locationCity;
    @Column(name="location_region")
    private String locationRegion;
    @Column(name="location_country")
    private String locationCountry;
    @Column(name="location_zip_code")
    private String locationZipCode;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    @Column(name="version", nullable=false)
    private long version;
    @Column(name="schedule_order", nullable=false)
    private long scheduleOrder;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="schedule")
    @OrderColumn(name="program_order")
    private List<ProgramEntity> programs;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now();
    }

    @Generated
    protected ScheduleEntity(ScheduleEntityBuilder<?, ?> b) {
        super(b);
        this.event = b.event;
        this.eventId = b.eventId;
        this.description = b.description;
        this.startDate = b.startDate;
        this.startTime = b.startTime;
        this.endTime = b.endTime;
        this.locationCity = b.locationCity;
        this.locationRegion = b.locationRegion;
        this.locationCountry = b.locationCountry;
        this.locationZipCode = b.locationZipCode;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
        this.scheduleOrder = b.scheduleOrder;
        this.programs = b.programs;
    }

    @Generated
    public static ScheduleEntityBuilder<?, ?> builder() {
        return new ScheduleEntityBuilderImpl();
    }

    @Generated
    public EventEntity getEvent() {
        return this.event;
    }

    @Generated
    public UUID getEventId() {
        return this.eventId;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getLocationCity() {
        return this.locationCity;
    }

    @Generated
    public String getLocationRegion() {
        return this.locationRegion;
    }

    @Generated
    public String getLocationCountry() {
        return this.locationCountry;
    }

    @Generated
    public String getLocationZipCode() {
        return this.locationZipCode;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public long getScheduleOrder() {
        return this.scheduleOrder;
    }

    @Generated
    public List<ProgramEntity> getPrograms() {
        return this.programs;
    }

    @Generated
    public void setEvent(EventEntity event) {
        this.event = event;
    }

    @Generated
    public void setEventId(UUID eventId) {
        this.eventId = eventId;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    @Generated
    public void setLocationRegion(String locationRegion) {
        this.locationRegion = locationRegion;
    }

    @Generated
    public void setLocationCountry(String locationCountry) {
        this.locationCountry = locationCountry;
    }

    @Generated
    public void setLocationZipCode(String locationZipCode) {
        this.locationZipCode = locationZipCode;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setScheduleOrder(long scheduleOrder) {
        this.scheduleOrder = scheduleOrder;
    }

    @Generated
    public void setPrograms(List<ProgramEntity> programs) {
        this.programs = programs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleEntity)) {
            return false;
        }
        ScheduleEntity other = (ScheduleEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getScheduleOrder() != other.getScheduleOrder()) {
            return false;
        }
        EventEntity this$event = this.getEvent();
        EventEntity other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        UUID this$eventId = this.getEventId();
        UUID other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !((Object)this$eventId).equals(other$eventId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalTime this$startTime = this.getStartTime();
        LocalTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalTime this$endTime = this.getEndTime();
        LocalTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$locationCity = this.getLocationCity();
        String other$locationCity = other.getLocationCity();
        if (this$locationCity == null ? other$locationCity != null : !this$locationCity.equals(other$locationCity)) {
            return false;
        }
        String this$locationRegion = this.getLocationRegion();
        String other$locationRegion = other.getLocationRegion();
        if (this$locationRegion == null ? other$locationRegion != null : !this$locationRegion.equals(other$locationRegion)) {
            return false;
        }
        String this$locationCountry = this.getLocationCountry();
        String other$locationCountry = other.getLocationCountry();
        if (this$locationCountry == null ? other$locationCountry != null : !this$locationCountry.equals(other$locationCountry)) {
            return false;
        }
        String this$locationZipCode = this.getLocationZipCode();
        String other$locationZipCode = other.getLocationZipCode();
        if (this$locationZipCode == null ? other$locationZipCode != null : !this$locationZipCode.equals(other$locationZipCode)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        List this$programs = this.getPrograms();
        List other$programs = other.getPrograms();
        return !(this$programs == null ? other$programs != null : !((Object)this$programs).equals(other$programs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduleEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $scheduleOrder = this.getScheduleOrder();
        result = result * 59 + (int)($scheduleOrder >>> 32 ^ $scheduleOrder);
        EventEntity $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        UUID $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : ((Object)$eventId).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $locationCity = this.getLocationCity();
        result = result * 59 + ($locationCity == null ? 43 : $locationCity.hashCode());
        String $locationRegion = this.getLocationRegion();
        result = result * 59 + ($locationRegion == null ? 43 : $locationRegion.hashCode());
        String $locationCountry = this.getLocationCountry();
        result = result * 59 + ($locationCountry == null ? 43 : $locationCountry.hashCode());
        String $locationZipCode = this.getLocationZipCode();
        result = result * 59 + ($locationZipCode == null ? 43 : $locationZipCode.hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        List $programs = this.getPrograms();
        result = result * 59 + ($programs == null ? 43 : ((Object)$programs).hashCode());
        return result;
    }

    @Generated
    public ScheduleEntity() {
    }
}

