/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedEventConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedEventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedScheduleEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.converter.StringListConverter;
import com.finconsgroup.itserr.marketplace.event.dm.model.InstitutionalPageModel;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="archived_event")
public class ArchivedEventEntity
extends AbstractUUIDEntity {
    @Column(name="title", nullable=false, length=255)
    private String title;
    @Column(name="event_planner_id", nullable=false)
    private UUID eventPlannerId;
    @Column(name="event_link", length=500)
    private String eventLink;
    @Column(name="event_type", nullable=false, length=50)
    private String eventType;
    @Column(name="content", length=800)
    private String content;
    @Column(name="max_participants")
    private Integer maxParticipants;
    @Column(name="subscribed_participants")
    private Integer subscribedParticipantsCount;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="tags")
    private List<String> tags;
    @JdbcTypeCode(value=3001)
    @Column(name="institutional_pages", columnDefinition="json")
    private List<InstitutionalPageModel> institutionalPages;
    @Column(name="image_id")
    private UUID imageId;
    @Column(name="image_url")
    private String imageUrl;
    @Column(name="timezone", nullable=false)
    private String timezone;
    @Column(name="start_date", nullable=false)
    private LocalDate startDate;
    @Column(name="end_date", nullable=false)
    private LocalDate endDate;
    @Column(name="maintainer_id", nullable=false)
    private UUID maintainerId;
    @Column(name="creation_time", nullable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Column(name="archive_time", nullable=false)
    private Instant archiveTime;
    @Column(name="version", nullable=false)
    private long version;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="event_id", nullable=false, updatable=false)
    private List<ArchivedEventConductorEntity> eventConductors;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="event_id", nullable=false, updatable=false)
    private List<ArchivedScheduleEntity> schedules;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="event")
    private List<ArchivedSubscribedParticipantEntity> subscribedParticipants;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
        if (this.archiveTime == null) {
            this.archiveTime = now;
        }
    }

    @Generated
    protected ArchivedEventEntity(ArchivedEventEntityBuilder<?, ?> b) {
        super(b);
        this.title = b.title;
        this.eventPlannerId = b.eventPlannerId;
        this.eventLink = b.eventLink;
        this.eventType = b.eventType;
        this.content = b.content;
        this.maxParticipants = b.maxParticipants;
        this.subscribedParticipantsCount = b.subscribedParticipantsCount;
        this.tags = b.tags;
        this.institutionalPages = b.institutionalPages;
        this.imageId = b.imageId;
        this.imageUrl = b.imageUrl;
        this.timezone = b.timezone;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.maintainerId = b.maintainerId;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.archiveTime = b.archiveTime;
        this.version = b.version;
        this.eventConductors = b.eventConductors;
        this.schedules = b.schedules;
        this.subscribedParticipants = b.subscribedParticipants;
    }

    @Generated
    public static ArchivedEventEntityBuilder<?, ?> builder() {
        return new ArchivedEventEntityBuilderImpl();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public UUID getEventPlannerId() {
        return this.eventPlannerId;
    }

    @Generated
    public String getEventLink() {
        return this.eventLink;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    @Generated
    public Integer getSubscribedParticipantsCount() {
        return this.subscribedParticipantsCount;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<InstitutionalPageModel> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public UUID getImageId() {
        return this.imageId;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Generated
    public UUID getMaintainerId() {
        return this.maintainerId;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Instant getArchiveTime() {
        return this.archiveTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public List<ArchivedEventConductorEntity> getEventConductors() {
        return this.eventConductors;
    }

    @Generated
    public List<ArchivedScheduleEntity> getSchedules() {
        return this.schedules;
    }

    @Generated
    public List<ArchivedSubscribedParticipantEntity> getSubscribedParticipants() {
        return this.subscribedParticipants;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setEventPlannerId(UUID eventPlannerId) {
        this.eventPlannerId = eventPlannerId;
    }

    @Generated
    public void setEventLink(String eventLink) {
        this.eventLink = eventLink;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @Generated
    public void setSubscribedParticipantsCount(Integer subscribedParticipantsCount) {
        this.subscribedParticipantsCount = subscribedParticipantsCount;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<InstitutionalPageModel> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImageId(UUID imageId) {
        this.imageId = imageId;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Generated
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setMaintainerId(UUID maintainerId) {
        this.maintainerId = maintainerId;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setArchiveTime(Instant archiveTime) {
        this.archiveTime = archiveTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setEventConductors(List<ArchivedEventConductorEntity> eventConductors) {
        this.eventConductors = eventConductors;
    }

    @Generated
    public void setSchedules(List<ArchivedScheduleEntity> schedules) {
        this.schedules = schedules;
    }

    @Generated
    public void setSubscribedParticipants(List<ArchivedSubscribedParticipantEntity> subscribedParticipants) {
        this.subscribedParticipants = subscribedParticipants;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedEventEntity)) {
            return false;
        }
        ArchivedEventEntity other = (ArchivedEventEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Integer this$maxParticipants = this.getMaxParticipants();
        Integer other$maxParticipants = other.getMaxParticipants();
        if (this$maxParticipants == null ? other$maxParticipants != null : !((Object)this$maxParticipants).equals(other$maxParticipants)) {
            return false;
        }
        Integer this$subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        Integer other$subscribedParticipantsCount = other.getSubscribedParticipantsCount();
        if (this$subscribedParticipantsCount == null ? other$subscribedParticipantsCount != null : !((Object)this$subscribedParticipantsCount).equals(other$subscribedParticipantsCount)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        UUID this$eventPlannerId = this.getEventPlannerId();
        UUID other$eventPlannerId = other.getEventPlannerId();
        if (this$eventPlannerId == null ? other$eventPlannerId != null : !((Object)this$eventPlannerId).equals(other$eventPlannerId)) {
            return false;
        }
        String this$eventLink = this.getEventLink();
        String other$eventLink = other.getEventLink();
        if (this$eventLink == null ? other$eventLink != null : !this$eventLink.equals(other$eventLink)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$institutionalPages = this.getInstitutionalPages();
        List other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        UUID this$imageId = this.getImageId();
        UUID other$imageId = other.getImageId();
        if (this$imageId == null ? other$imageId != null : !((Object)this$imageId).equals(other$imageId)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        UUID this$maintainerId = this.getMaintainerId();
        UUID other$maintainerId = other.getMaintainerId();
        if (this$maintainerId == null ? other$maintainerId != null : !((Object)this$maintainerId).equals(other$maintainerId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Instant this$archiveTime = this.getArchiveTime();
        Instant other$archiveTime = other.getArchiveTime();
        if (this$archiveTime == null ? other$archiveTime != null : !((Object)this$archiveTime).equals(other$archiveTime)) {
            return false;
        }
        List this$eventConductors = this.getEventConductors();
        List other$eventConductors = other.getEventConductors();
        if (this$eventConductors == null ? other$eventConductors != null : !((Object)this$eventConductors).equals(other$eventConductors)) {
            return false;
        }
        List this$schedules = this.getSchedules();
        List other$schedules = other.getSchedules();
        if (this$schedules == null ? other$schedules != null : !((Object)this$schedules).equals(other$schedules)) {
            return false;
        }
        List this$subscribedParticipants = this.getSubscribedParticipants();
        List other$subscribedParticipants = other.getSubscribedParticipants();
        return !(this$subscribedParticipants == null ? other$subscribedParticipants != null : !((Object)this$subscribedParticipants).equals(other$subscribedParticipants));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedEventEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Integer $maxParticipants = this.getMaxParticipants();
        result = result * 59 + ($maxParticipants == null ? 43 : ((Object)$maxParticipants).hashCode());
        Integer $subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        result = result * 59 + ($subscribedParticipantsCount == null ? 43 : ((Object)$subscribedParticipantsCount).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        UUID $eventPlannerId = this.getEventPlannerId();
        result = result * 59 + ($eventPlannerId == null ? 43 : ((Object)$eventPlannerId).hashCode());
        String $eventLink = this.getEventLink();
        result = result * 59 + ($eventLink == null ? 43 : $eventLink.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        UUID $imageId = this.getImageId();
        result = result * 59 + ($imageId == null ? 43 : ((Object)$imageId).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        UUID $maintainerId = this.getMaintainerId();
        result = result * 59 + ($maintainerId == null ? 43 : ((Object)$maintainerId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Instant $archiveTime = this.getArchiveTime();
        result = result * 59 + ($archiveTime == null ? 43 : ((Object)$archiveTime).hashCode());
        List $eventConductors = this.getEventConductors();
        result = result * 59 + ($eventConductors == null ? 43 : ((Object)$eventConductors).hashCode());
        List $schedules = this.getSchedules();
        result = result * 59 + ($schedules == null ? 43 : ((Object)$schedules).hashCode());
        List $subscribedParticipants = this.getSubscribedParticipants();
        result = result * 59 + ($subscribedParticipants == null ? 43 : ((Object)$subscribedParticipants).hashCode());
        return result;
    }

    @Generated
    public ArchivedEventEntity() {
    }
}

