/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputImageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputImageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.SubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.EventConductorMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.EventMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.ScheduleMapper;
import com.finconsgroup.itserr.marketplace.event.dm.model.InstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.event.dm.service.impl.DefaultEventService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventMapperImpl
implements EventMapper {
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private EventConductorMapper eventConductorMapper;

    public EventEntity toEntity(InputCreateEventDto inputCreateEventDto) {
        if (inputCreateEventDto == null) {
            return null;
        }
        EventEntity.EventEntityBuilder eventEntity = EventEntity.builder();
        eventEntity.imageId(this.inputCreateEventDtoImageId(inputCreateEventDto));
        eventEntity.imageUrl(this.inputCreateEventDtoImageUrl(inputCreateEventDto));
        eventEntity.title(inputCreateEventDto.getTitle());
        eventEntity.eventLink(inputCreateEventDto.getEventLink());
        eventEntity.eventType(inputCreateEventDto.getEventType());
        eventEntity.content(inputCreateEventDto.getContent());
        eventEntity.maxParticipants(inputCreateEventDto.getMaxParticipants());
        List list = inputCreateEventDto.getTags();
        if (list != null) {
            eventEntity.tags(new ArrayList(list));
        }
        eventEntity.institutionalPages(this.inputInstitutionalPageDtoListToInstitutionalPageModelList(inputCreateEventDto.getInstitutionalPages()));
        eventEntity.timezone(inputCreateEventDto.getTimezone());
        eventEntity.eventConductors(this.inputEventConductorDtoListToEventConductorEntityList(inputCreateEventDto.getEventConductors()));
        eventEntity.schedules(this.scheduleMapper.toEntityList(inputCreateEventDto.getSchedules()));
        return eventEntity.build();
    }

    public OutputEventDto toDto(EventEntity eventEntity) {
        if (eventEntity == null) {
            return null;
        }
        OutputEventDto.OutputEventDtoBuilder outputEventDto = OutputEventDto.builder();
        outputEventDto.image(this.eventEntityToOutputImageDto(eventEntity));
        outputEventDto.id(eventEntity.getId());
        outputEventDto.title(eventEntity.getTitle());
        outputEventDto.eventLink(eventEntity.getEventLink());
        outputEventDto.eventType(eventEntity.getEventType());
        outputEventDto.content(eventEntity.getContent());
        outputEventDto.maxParticipants(eventEntity.getMaxParticipants());
        outputEventDto.subscribedParticipantsCount(eventEntity.getSubscribedParticipantsCount());
        List list = eventEntity.getTags();
        if (list != null) {
            outputEventDto.tags(new ArrayList(list));
        }
        outputEventDto.institutionalPages(this.institutionalPageModelListToOutputInstitutionalPageDtoList(eventEntity.getInstitutionalPages()));
        outputEventDto.timezone(eventEntity.getTimezone());
        outputEventDto.startDate(eventEntity.getStartDate());
        outputEventDto.endDate(eventEntity.getEndDate());
        outputEventDto.eventConductors(this.eventConductorEntityListToOutputEventConductorDtoList(eventEntity.getEventConductors()));
        outputEventDto.schedules(this.scheduleEntityListToOutputScheduleDtoList(eventEntity.getSchedules()));
        outputEventDto.subscribedParticipants(this.subscribedParticipantEntityListToOutputSubscribedParticipantDtoList(eventEntity.getSubscribedParticipants()));
        outputEventDto.eventPlannerId(eventEntity.getEventPlannerId());
        outputEventDto.maintainerId(eventEntity.getMaintainerId());
        outputEventDto.creationTime(eventEntity.getCreationTime());
        outputEventDto.updateTime(eventEntity.getUpdateTime());
        return outputEventDto.build();
    }

    public OutputEventDto toDtoWithAssociations(EventEntity eventEntity, DefaultEventService.Associations associations) {
        if (eventEntity == null && associations == null) {
            return null;
        }
        OutputEventDto.OutputEventDtoBuilder outputEventDto = OutputEventDto.builder();
        if (eventEntity != null) {
            outputEventDto.image(this.eventEntityToOutputImageDto1(eventEntity));
            outputEventDto.id(eventEntity.getId());
            outputEventDto.title(eventEntity.getTitle());
            outputEventDto.eventLink(eventEntity.getEventLink());
            outputEventDto.eventType(eventEntity.getEventType());
            outputEventDto.content(eventEntity.getContent());
            outputEventDto.maxParticipants(eventEntity.getMaxParticipants());
            outputEventDto.subscribedParticipantsCount(eventEntity.getSubscribedParticipantsCount());
            List list3 = eventEntity.getTags();
            if (list3 != null) {
                outputEventDto.tags(new ArrayList(list3));
            }
            outputEventDto.institutionalPages(this.institutionalPageModelListToOutputInstitutionalPageDtoList(eventEntity.getInstitutionalPages()));
            outputEventDto.timezone(eventEntity.getTimezone());
            outputEventDto.startDate(eventEntity.getStartDate());
            outputEventDto.endDate(eventEntity.getEndDate());
            outputEventDto.eventPlannerId(eventEntity.getEventPlannerId());
            outputEventDto.maintainerId(eventEntity.getMaintainerId());
            outputEventDto.creationTime(eventEntity.getCreationTime());
            outputEventDto.updateTime(eventEntity.getUpdateTime());
        }
        if (associations != null) {
            List list2;
            List list1;
            List list = associations.getEventConductors();
            if (list != null) {
                outputEventDto.eventConductors(new ArrayList(list));
            }
            if ((list1 = associations.getSchedules()) != null) {
                outputEventDto.schedules(new ArrayList(list1));
            }
            if ((list2 = associations.getSubscribedParticipants()) != null) {
                outputEventDto.subscribedParticipants(new ArrayList(list2));
            }
        }
        return outputEventDto.build();
    }

    public void updateEntity(InputUpdateEventDto dto, EventEntity entity) {
        if (dto == null) {
            return;
        }
        entity.setImageId(this.dtoImageId(dto));
        entity.setImageUrl(this.dtoImageUrl(dto));
        entity.setTitle(dto.getTitle());
        entity.setEventLink(dto.getEventLink());
        entity.setEventType(dto.getEventType());
        entity.setContent(dto.getContent());
        entity.setMaxParticipants(dto.getMaxParticipants());
        if (entity.getTags() != null) {
            list = dto.getTags();
            if (list != null) {
                entity.getTags().clear();
                entity.getTags().addAll(list);
            } else {
                entity.setTags(null);
            }
        } else {
            list = dto.getTags();
            if (list != null) {
                entity.setTags(new ArrayList(list));
            }
        }
        if (entity.getInstitutionalPages() != null) {
            list1 = this.inputInstitutionalPageDtoListToInstitutionalPageModelList1(dto.getInstitutionalPages());
            if (list1 != null) {
                entity.getInstitutionalPages().clear();
                entity.getInstitutionalPages().addAll(list1);
            } else {
                entity.setInstitutionalPages(null);
            }
        } else {
            list1 = this.inputInstitutionalPageDtoListToInstitutionalPageModelList1(dto.getInstitutionalPages());
            if (list1 != null) {
                entity.setInstitutionalPages(list1);
            }
        }
        entity.setTimezone(dto.getTimezone());
    }

    private UUID inputCreateEventDtoImageId(InputCreateEventDto inputCreateEventDto) {
        InputImageDto image = inputCreateEventDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getId();
    }

    private String inputCreateEventDtoImageUrl(InputCreateEventDto inputCreateEventDto) {
        InputImageDto image = inputCreateEventDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getUrl();
    }

    protected InstitutionalPageModel inputInstitutionalPageDtoToInstitutionalPageModel(InputInstitutionalPageDto inputInstitutionalPageDto) {
        if (inputInstitutionalPageDto == null) {
            return null;
        }
        InstitutionalPageModel.InstitutionalPageModelBuilder institutionalPageModel = InstitutionalPageModel.builder();
        institutionalPageModel.id(inputInstitutionalPageDto.getId());
        institutionalPageModel.name(inputInstitutionalPageDto.getName());
        return institutionalPageModel.build();
    }

    protected List<InstitutionalPageModel> inputInstitutionalPageDtoListToInstitutionalPageModelList(List<InputInstitutionalPageDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<InstitutionalPageModel> list1 = new ArrayList<InstitutionalPageModel>(list.size());
        for (InputInstitutionalPageDto inputInstitutionalPageDto : list) {
            list1.add(this.inputInstitutionalPageDtoToInstitutionalPageModel(inputInstitutionalPageDto));
        }
        return list1;
    }

    protected List<EventConductorEntity> inputEventConductorDtoListToEventConductorEntityList(List<InputEventConductorDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<EventConductorEntity> list1 = new ArrayList<EventConductorEntity>(list.size());
        for (InputEventConductorDto inputEventConductorDto : list) {
            list1.add(this.eventConductorMapper.toEntity(inputEventConductorDto));
        }
        return list1;
    }

    protected OutputImageDto eventEntityToOutputImageDto(EventEntity eventEntity) {
        if (eventEntity == null) {
            return null;
        }
        OutputImageDto.OutputImageDtoBuilder outputImageDto = OutputImageDto.builder();
        outputImageDto.id(eventEntity.getImageId());
        outputImageDto.url(eventEntity.getImageUrl());
        return outputImageDto.build();
    }

    protected OutputInstitutionalPageDto institutionalPageModelToOutputInstitutionalPageDto(InstitutionalPageModel institutionalPageModel) {
        if (institutionalPageModel == null) {
            return null;
        }
        OutputInstitutionalPageDto.OutputInstitutionalPageDtoBuilder outputInstitutionalPageDto = OutputInstitutionalPageDto.builder();
        outputInstitutionalPageDto.id(institutionalPageModel.getId());
        outputInstitutionalPageDto.name(institutionalPageModel.getName());
        return outputInstitutionalPageDto.build();
    }

    protected List<OutputInstitutionalPageDto> institutionalPageModelListToOutputInstitutionalPageDtoList(List<InstitutionalPageModel> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputInstitutionalPageDto> list1 = new ArrayList<OutputInstitutionalPageDto>(list.size());
        for (InstitutionalPageModel institutionalPageModel : list) {
            list1.add(this.institutionalPageModelToOutputInstitutionalPageDto(institutionalPageModel));
        }
        return list1;
    }

    protected List<OutputEventConductorDto> eventConductorEntityListToOutputEventConductorDtoList(List<EventConductorEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputEventConductorDto> list1 = new ArrayList<OutputEventConductorDto>(list.size());
        for (EventConductorEntity eventConductorEntity : list) {
            list1.add(this.eventConductorMapper.toDto(eventConductorEntity));
        }
        return list1;
    }

    protected List<OutputScheduleDto> scheduleEntityListToOutputScheduleDtoList(List<ScheduleEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputScheduleDto> list1 = new ArrayList<OutputScheduleDto>(list.size());
        for (ScheduleEntity scheduleEntity : list) {
            list1.add(this.scheduleMapper.toDto(scheduleEntity));
        }
        return list1;
    }

    protected OutputSubscribedParticipantDto subscribedParticipantEntityToOutputSubscribedParticipantDto(SubscribedParticipantEntity subscribedParticipantEntity) {
        if (subscribedParticipantEntity == null) {
            return null;
        }
        OutputSubscribedParticipantDto.OutputSubscribedParticipantDtoBuilder outputSubscribedParticipantDto = OutputSubscribedParticipantDto.builder();
        outputSubscribedParticipantDto.id(subscribedParticipantEntity.getId());
        outputSubscribedParticipantDto.eventId(subscribedParticipantEntity.getEventId());
        outputSubscribedParticipantDto.userId(subscribedParticipantEntity.getUserId());
        outputSubscribedParticipantDto.creationTime(subscribedParticipantEntity.getCreationTime());
        outputSubscribedParticipantDto.updateTime(subscribedParticipantEntity.getUpdateTime());
        return outputSubscribedParticipantDto.build();
    }

    protected List<OutputSubscribedParticipantDto> subscribedParticipantEntityListToOutputSubscribedParticipantDtoList(List<SubscribedParticipantEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputSubscribedParticipantDto> list1 = new ArrayList<OutputSubscribedParticipantDto>(list.size());
        for (SubscribedParticipantEntity subscribedParticipantEntity : list) {
            list1.add(this.subscribedParticipantEntityToOutputSubscribedParticipantDto(subscribedParticipantEntity));
        }
        return list1;
    }

    protected OutputImageDto eventEntityToOutputImageDto1(EventEntity eventEntity) {
        if (eventEntity == null) {
            return null;
        }
        OutputImageDto.OutputImageDtoBuilder outputImageDto = OutputImageDto.builder();
        outputImageDto.id(eventEntity.getImageId());
        outputImageDto.url(eventEntity.getImageUrl());
        return outputImageDto.build();
    }

    private UUID dtoImageId(InputUpdateEventDto inputUpdateEventDto) {
        InputImageDto image = inputUpdateEventDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getId();
    }

    private String dtoImageUrl(InputUpdateEventDto inputUpdateEventDto) {
        InputImageDto image = inputUpdateEventDto.getImage();
        if (image == null) {
            return null;
        }
        return image.getUrl();
    }

    protected List<InstitutionalPageModel> inputInstitutionalPageDtoListToInstitutionalPageModelList1(List<InputInstitutionalPageDto> list) {
        if (list == null) {
            return new ArrayList<InstitutionalPageModel>();
        }
        ArrayList<InstitutionalPageModel> list1 = new ArrayList<InstitutionalPageModel>(list.size());
        for (InputInstitutionalPageDto inputInstitutionalPageDto : list) {
            list1.add(this.inputInstitutionalPageDtoToInstitutionalPageModel(inputInstitutionalPageDto));
        }
        return list1;
    }
}

