/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.converter.StringListConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="program")
public class ProgramEntity
extends AbstractUUIDEntity {
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="schedule_id", updatable=false)
    private ScheduleEntity schedule;
    @Column(name="schedule_id", insertable=false, updatable=false)
    private UUID scheduleId;
    @Column(name="title", nullable=false, length=255)
    private String title;
    @Column(name="description", length=255)
    private String description;
    @Column(name="program_link", length=500)
    private String programLink;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="program_conductors")
    private List<String> programConductors;
    @Column(name="place", length=255)
    private String place;
    @Column(name="start_time", nullable=false)
    private LocalTime startTime;
    @Column(name="end_time", nullable=false)
    private LocalTime endTime;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    @Column(name="version", nullable=false)
    private long version;
    @Column(name="program_order", nullable=false)
    private long programOrder;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now();
    }

    @Generated
    protected ProgramEntity(ProgramEntityBuilder<?, ?> b) {
        super(b);
        this.schedule = b.schedule;
        this.scheduleId = b.scheduleId;
        this.title = b.title;
        this.description = b.description;
        this.programLink = b.programLink;
        this.programConductors = b.programConductors;
        this.place = b.place;
        this.startTime = b.startTime;
        this.endTime = b.endTime;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
        this.programOrder = b.programOrder;
    }

    @Generated
    public static ProgramEntityBuilder<?, ?> builder() {
        return new ProgramEntityBuilderImpl();
    }

    @Generated
    public ScheduleEntity getSchedule() {
        return this.schedule;
    }

    @Generated
    public UUID getScheduleId() {
        return this.scheduleId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getProgramLink() {
        return this.programLink;
    }

    @Generated
    public List<String> getProgramConductors() {
        return this.programConductors;
    }

    @Generated
    public String getPlace() {
        return this.place;
    }

    @Generated
    public LocalTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public long getProgramOrder() {
        return this.programOrder;
    }

    @Generated
    public void setSchedule(ScheduleEntity schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setScheduleId(UUID scheduleId) {
        this.scheduleId = scheduleId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProgramLink(String programLink) {
        this.programLink = programLink;
    }

    @Generated
    public void setProgramConductors(List<String> programConductors) {
        this.programConductors = programConductors;
    }

    @Generated
    public void setPlace(String place) {
        this.place = place;
    }

    @Generated
    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setProgramOrder(long programOrder) {
        this.programOrder = programOrder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgramEntity)) {
            return false;
        }
        ProgramEntity other = (ProgramEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getProgramOrder() != other.getProgramOrder()) {
            return false;
        }
        ScheduleEntity this$schedule = this.getSchedule();
        ScheduleEntity other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        UUID this$scheduleId = this.getScheduleId();
        UUID other$scheduleId = other.getScheduleId();
        if (this$scheduleId == null ? other$scheduleId != null : !((Object)this$scheduleId).equals(other$scheduleId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$programLink = this.getProgramLink();
        String other$programLink = other.getProgramLink();
        if (this$programLink == null ? other$programLink != null : !this$programLink.equals(other$programLink)) {
            return false;
        }
        List this$programConductors = this.getProgramConductors();
        List other$programConductors = other.getProgramConductors();
        if (this$programConductors == null ? other$programConductors != null : !((Object)this$programConductors).equals(other$programConductors)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        LocalTime this$startTime = this.getStartTime();
        LocalTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalTime this$endTime = this.getEndTime();
        LocalTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProgramEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $programOrder = this.getProgramOrder();
        result = result * 59 + (int)($programOrder >>> 32 ^ $programOrder);
        ScheduleEntity $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        UUID $scheduleId = this.getScheduleId();
        result = result * 59 + ($scheduleId == null ? 43 : ((Object)$scheduleId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $programLink = this.getProgramLink();
        result = result * 59 + ($programLink == null ? 43 : $programLink.hashCode());
        List $programConductors = this.getProgramConductors();
        result = result * 59 + ($programConductors == null ? 43 : ((Object)$programConductors).hashCode());
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        LocalTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ProgramEntity() {
    }
}

