/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedEventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.SubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.ArchivedEventMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.ArchivedSubscribedParticipantMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.EventConductorMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.EventMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.ProgramMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.ScheduleMapper;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.SubscribedParticipantMapper;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ArchivedEventRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ArchivedSubscribedParticipantRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.EventConductorRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.EventRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ProgramRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ScheduleRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.SubscribedParticipantRepository;
import com.finconsgroup.itserr.marketplace.event.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.event.dm.service.impl.DefaultEventService;
import com.finconsgroup.itserr.marketplace.event.dm.util.DateTimeUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultEventService
implements EventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventService.class);
    private static final String ASSOCIATION_ALL = "all";
    private static final String ASSOCIATION_EVENT_CONDUCTORS = "eventConductors";
    private static final String ASSOCIATION_SCHEDULES = "schedules";
    private static final String ASSOCIATION_SUBSCRIBED_PARTICIPANTS = "subscribedParticipants";
    private static final String ASSOCIATION_PROGRAMS = "programs";
    private static final String FORMAT_BUSINESS_KEY = "{userId: %s, eventId: %s}";
    private final EventRepository eventRepository;
    private final EventMapper eventMapper;
    private final EventConductorRepository eventConductorRepository;
    private final EventConductorMapper eventConductorMapper;
    private final ScheduleRepository scheduleRepository;
    private final ScheduleMapper scheduleMapper;
    private final ProgramRepository programRepository;
    private final ProgramMapper programMapper;
    private final SubscribedParticipantRepository subscribedParticipantRepository;
    private final SubscribedParticipantMapper subscribedParticipantMapper;
    private final ArchivedEventRepository archivedEventRepository;
    private final ArchivedEventMapper archivedEventMapper;
    private final ArchivedSubscribedParticipantRepository archivedSubscribedParticipantRepository;
    private final ArchivedSubscribedParticipantMapper archivedSubscribedParticipantMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputEventDto> findAll(Set<String> associationsToLoad, @NonNull Pageable pageable) {
        Page eventEntityPage = this.eventRepository.findAll(pageable);
        return this.mapEntitiesToDtos(eventEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputEventDto findById(UUID userId, @NonNull UUID eventId) {
        EventEntity eventEntity = this.findByIdOrThrow(eventId);
        OutputEventDto outputEventDto = this.eventMapper.toDto(eventEntity);
        if (userId != null) {
            outputEventDto.setSubscribed(this.checkSubscription(outputEventDto, userId));
        }
        return outputEventDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEventDto create(@NonNull UUID userId, @NonNull InputCreateEventDto inputCreateEventDto) {
        EventEntity eventEntity = this.eventMapper.toEntity(inputCreateEventDto);
        eventEntity.setEventPlannerId(userId);
        eventEntity.setMaintainerId(userId);
        this.updateAssociationsForSave(eventEntity);
        eventEntity.setSubscribedParticipantsCount(Integer.valueOf(0));
        return this.eventMapper.toDto((EventEntity)this.eventRepository.saveAndFlush((Object)eventEntity));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEventDto updateById(@NonNull UUID userId, @NonNull UUID eventId, @NonNull InputUpdateEventDto inputUpdateEventDto) {
        EventEntity eventEntity = this.findByUserIdAndIdOrThrow(userId, eventId);
        this.updateEntity(inputUpdateEventDto, eventEntity);
        this.updateAssociationsForSave(eventEntity);
        EventEntity savedEventEntity = (EventEntity)this.eventRepository.saveAndFlush((Object)eventEntity);
        OutputEventDto outputEventDto = this.eventMapper.toDto(savedEventEntity);
        outputEventDto.setSubscribed(this.checkSubscription(outputEventDto, userId));
        return outputEventDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NonNull UUID userId, @NonNull UUID eventId) {
        EventEntity eventEntity = this.findByUserIdAndIdOrThrow(userId, eventId);
        ArchivedEventEntity archivedEventEntity = this.archivedEventMapper.toArchivedEntity(eventEntity);
        archivedEventEntity.getSubscribedParticipants().forEach(archivedSPEntity -> archivedSPEntity.setEvent(archivedEventEntity));
        this.archivedEventRepository.save((Object)archivedEventEntity);
        this.eventRepository.delete((Object)eventEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEventDto register(@NonNull UUID userId, @NonNull UUID eventId) {
        EventEntity existingEventEntity = this.findByIdOrThrow(eventId);
        if (this.subscribedParticipantRepository.existsByUserIdAndEventId(userId, eventId)) {
            throw new WP2DuplicateResourceException("{userId: %s, eventId: %s}".formatted(userId, eventId));
        }
        SubscribedParticipantEntity subscribedParticipantEntity = SubscribedParticipantEntity.builder().userId(userId).eventId(eventId).event(existingEventEntity).participantOrder((long)existingEventEntity.getSubscribedParticipantsCount().intValue()).build();
        this.subscribedParticipantRepository.saveAndFlush((Object)subscribedParticipantEntity);
        EventEntity eventEntity = this.findByIdOrThrow(eventId);
        eventEntity.incrementParticipants();
        this.eventRepository.saveAndFlush((Object)eventEntity);
        OutputEventDto outputEventDto = this.eventMapper.toDto(eventEntity);
        outputEventDto.setSubscribed(Boolean.valueOf(true));
        return outputEventDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEventDto unregister(@NonNull UUID userId, @NonNull UUID eventId) {
        SubscribedParticipantEntity subscribedParticipantEntity = (SubscribedParticipantEntity)this.subscribedParticipantRepository.findByUserIdAndEventId(userId, eventId).orElseThrow(() -> new WP2ResourceNotFoundException("{userId: %s, eventId: %s}".formatted(userId, eventId)));
        this.subscribedParticipantRepository.delete((Object)subscribedParticipantEntity);
        ArchivedSubscribedParticipantEntity archivedSubscribedParticipantEntity = this.archivedSubscribedParticipantMapper.toArchivedSubscribedParticipantEntity(subscribedParticipantEntity);
        archivedSubscribedParticipantEntity.setEvent(((ArchivedEventEntity.ArchivedEventEntityBuilder)ArchivedEventEntity.builder().id(eventId)).build());
        this.archivedSubscribedParticipantRepository.save((Object)archivedSubscribedParticipantEntity);
        this.eventRepository.flush();
        EventEntity eventEntity = this.findByIdOrThrow(eventId);
        eventEntity.decrementParticipants();
        this.eventRepository.saveAndFlush((Object)eventEntity);
        OutputEventDto outputEventDto = this.eventMapper.toDto(eventEntity);
        outputEventDto.setSubscribed(Boolean.valueOf(false));
        return outputEventDto;
    }

    private EventEntity findByIdOrThrow(@NonNull UUID eventId) {
        return (EventEntity)this.eventRepository.findById((Object)eventId).orElseThrow(() -> new WP2ResourceNotFoundException(eventId));
    }

    private Boolean checkSubscription(@NonNull OutputEventDto outputEventDto, @NonNull UUID userId) {
        return Optional.ofNullable(outputEventDto.getSubscribedParticipants()).orElse(List.of()).stream().anyMatch(dto -> userId.equals(dto.getUserId()));
    }

    private EventEntity findByUserIdAndIdOrThrow(@NonNull UUID userId, @NonNull UUID eventId) {
        return (EventEntity)this.eventRepository.findByMaintainerIdAndId(userId, eventId).orElseThrow(() -> new WP2ResourceNotFoundException(eventId));
    }

    private Page<OutputEventDto> mapEntitiesToDtos(Page<EventEntity> eventEntityPage, Set<String> associationsToLoad) {
        Set associationsToLoadOrDefault = Optional.ofNullable(associationsToLoad).orElse(Set.of());
        LoadedAssociations loadedAssociations = this.loadAssociations(eventEntityPage, associationsToLoadOrDefault);
        return eventEntityPage.map(entity -> this.mapEntityToDtoWithAssociations(entity, associationsToLoadOrDefault, loadedAssociations));
    }

    private LoadedAssociations loadAssociations(Page<EventEntity> eventEntityPage, Set<String> associationsToLoad) {
        List subscribedParticipantEntities;
        List scheduleEntities;
        LoadedAssociations loadedAssociations = new LoadedAssociations();
        List<UUID> loadedEventIds = eventEntityPage.getContent().stream().map(AbstractUUIDEntity::getId).toList();
        boolean loadAllAssociations = associationsToLoad.contains("all");
        if ((loadAllAssociations || associationsToLoad.contains("eventConductors")) && !loadedEventIds.isEmpty()) {
            this.eventConductorRepository.findAllByEventIdIn(loadedEventIds).forEach(entity -> loadedAssociations.eventConductorsMap.computeIfAbsent(entity.getEventId(), k -> new LinkedList()).add(this.eventConductorMapper.toDto(entity)));
        }
        if ((loadAllAssociations || associationsToLoad.contains("schedules") || associationsToLoad.contains("programs")) && !loadedEventIds.isEmpty() && !(scheduleEntities = this.scheduleRepository.findAllByEventIdIn(loadedEventIds)).isEmpty()) {
            List programEntities;
            scheduleEntities.forEach(entity -> loadedAssociations.schedulesMap.computeIfAbsent(entity.getEventId(), k -> new LinkedList()).add(this.scheduleMapper.toDto(entity)));
            if ((loadAllAssociations || associationsToLoad.contains("programs")) && !(programEntities = this.programRepository.findAllByScheduleEventIdIn(loadedEventIds)).isEmpty()) {
                programEntities.forEach(entity -> loadedAssociations.programsMap.computeIfAbsent(entity.getScheduleId(), k -> new LinkedList()).add(this.programMapper.toDto(entity)));
            }
        }
        if ((loadAllAssociations || associationsToLoad.contains("subscribedParticipants")) && !(subscribedParticipantEntities = this.subscribedParticipantRepository.findAllByEventIdIn(loadedEventIds)).isEmpty()) {
            subscribedParticipantEntities.forEach(entity -> loadedAssociations.subscribedParticipantsMap.computeIfAbsent(entity.getEventId(), k -> new LinkedList()).add(this.subscribedParticipantMapper.toDto(entity)));
        }
        return loadedAssociations;
    }

    private OutputEventDto mapEntityToDtoWithAssociations(EventEntity eventEntity, Set<String> associationsToLoad, LoadedAssociations loadedAssociations) {
        Associations.AssociationsBuilder associationsBuilder = Associations.builder();
        boolean loadAllAssociations = associationsToLoad.contains("all");
        if (loadAllAssociations || associationsToLoad.contains("eventConductors")) {
            associationsBuilder.eventConductors((List)loadedAssociations.eventConductorsMap.get(eventEntity.getId()));
        }
        if (loadAllAssociations || associationsToLoad.contains("schedules") || associationsToLoad.contains("programs")) {
            List scheduleDtos = (List)loadedAssociations.schedulesMap.get(eventEntity.getId());
            if (loadAllAssociations || associationsToLoad.contains("programs")) {
                scheduleDtos.forEach(outputScheduleDto -> outputScheduleDto.setPrograms((List)loadedAssociations.programsMap.get(outputScheduleDto.getId())));
            }
            associationsBuilder.schedules(scheduleDtos);
        }
        if (loadAllAssociations || associationsToLoad.contains("subscribedParticipants")) {
            associationsBuilder.subscribedParticipants((List)loadedAssociations.subscribedParticipantsMap.get(eventEntity.getId()));
        }
        OutputEventDto outputEventDto = this.eventMapper.toDtoWithAssociations(eventEntity, associationsBuilder.build());
        return outputEventDto;
    }

    private void updateEntity(InputUpdateEventDto inputUpdateEventDto, EventEntity eventEntity) {
        this.eventMapper.updateEntity(inputUpdateEventDto, eventEntity);
        this.updateEventConductors(inputUpdateEventDto, eventEntity);
        this.updateSchedules(inputUpdateEventDto, eventEntity);
        this.updateAssociationsForSave(eventEntity);
    }

    private void updateEventConductors(InputUpdateEventDto inputUpdateEventDto, EventEntity eventEntity) {
        EventConductorEntity eventConductorEntity;
        InputEventConductorDto inputEventConductorDto;
        ListIterator entityEventConductorsIterator;
        ListIterator inputEventConductorsDtoIterator = inputUpdateEventDto.getEventConductors() != null ? inputUpdateEventDto.getEventConductors().listIterator() : Collections.emptyListIterator();
        ListIterator<Object> listIterator = entityEventConductorsIterator = eventEntity.getEventConductors() != null ? eventEntity.getEventConductors().listIterator() : Collections.emptyListIterator();
        while (inputEventConductorsDtoIterator.hasNext() && entityEventConductorsIterator.hasNext()) {
            inputEventConductorDto = (InputEventConductorDto)inputEventConductorsDtoIterator.next();
            eventConductorEntity = (EventConductorEntity)entityEventConductorsIterator.next();
            this.eventConductorMapper.updateEntity(inputEventConductorDto, eventConductorEntity);
        }
        while (inputEventConductorsDtoIterator.hasNext()) {
            inputEventConductorDto = (InputEventConductorDto)inputEventConductorsDtoIterator.next();
            eventConductorEntity = this.eventConductorMapper.toEntity(inputEventConductorDto);
            entityEventConductorsIterator.add(eventConductorEntity);
        }
        while (entityEventConductorsIterator.hasNext()) {
            entityEventConductorsIterator.next();
            entityEventConductorsIterator.remove();
        }
    }

    private void updateSchedules(InputUpdateEventDto inputUpdateEventDto, EventEntity eventEntity) {
        ScheduleEntity scheduleEntity;
        InputScheduleDto inputScheduleDto;
        ListIterator entitySchedulesIterator;
        ListIterator inputSchedulesDtoIterator = inputUpdateEventDto.getSchedules() != null ? inputUpdateEventDto.getSchedules().listIterator() : Collections.emptyListIterator();
        ListIterator<Object> listIterator = entitySchedulesIterator = eventEntity.getSchedules() != null ? eventEntity.getSchedules().listIterator() : Collections.emptyListIterator();
        while (inputSchedulesDtoIterator.hasNext() && entitySchedulesIterator.hasNext()) {
            inputScheduleDto = (InputScheduleDto)inputSchedulesDtoIterator.next();
            scheduleEntity = (ScheduleEntity)entitySchedulesIterator.next();
            this.updateScheduleEntity(inputScheduleDto, scheduleEntity);
        }
        while (inputSchedulesDtoIterator.hasNext()) {
            inputScheduleDto = (InputScheduleDto)inputSchedulesDtoIterator.next();
            scheduleEntity = this.scheduleMapper.toEntity(inputScheduleDto);
            entitySchedulesIterator.add(scheduleEntity);
        }
        while (entitySchedulesIterator.hasNext()) {
            entitySchedulesIterator.next();
            entitySchedulesIterator.remove();
        }
    }

    private void updateScheduleEntity(InputScheduleDto inputScheduleDto, ScheduleEntity scheduleEntity) {
        this.scheduleMapper.updateEntity(inputScheduleDto, scheduleEntity);
        this.updatePrograms(inputScheduleDto, scheduleEntity);
    }

    private void updatePrograms(InputScheduleDto inputScheduleDto, ScheduleEntity scheduleEntity) {
        ProgramEntity programEntity;
        InputProgramDto inputProgramDto;
        ListIterator entityProgramsIterator;
        ListIterator inputProgramsDtoIterator = inputScheduleDto.getPrograms() != null ? inputScheduleDto.getPrograms().listIterator() : Collections.emptyListIterator();
        ListIterator<Object> listIterator = entityProgramsIterator = scheduleEntity.getPrograms() != null ? scheduleEntity.getPrograms().listIterator() : Collections.emptyListIterator();
        while (inputProgramsDtoIterator.hasNext() && entityProgramsIterator.hasNext()) {
            inputProgramDto = (InputProgramDto)inputProgramsDtoIterator.next();
            programEntity = (ProgramEntity)entityProgramsIterator.next();
            this.programMapper.updateEntity(inputProgramDto, programEntity);
        }
        while (inputProgramsDtoIterator.hasNext()) {
            inputProgramDto = (InputProgramDto)inputProgramsDtoIterator.next();
            programEntity = this.programMapper.toEntity(inputProgramDto);
            entityProgramsIterator.add(programEntity);
        }
        while (entityProgramsIterator.hasNext()) {
            entityProgramsIterator.next();
            entityProgramsIterator.remove();
        }
    }

    private void updateAssociationsForSave(@NonNull EventEntity eventEntity) {
        LocalDate eventStartDate = null;
        LocalDate eventEndDate = null;
        LocalTime schdeduleStartTime = null;
        LocalTime scheduleEndTime = null;
        for (EventConductorEntity eventConductorEntity : eventEntity.getEventConductors()) {
            eventConductorEntity.setEvent(eventEntity);
        }
        for (ScheduleEntity scheduleEntity : eventEntity.getSchedules()) {
            eventStartDate = DateTimeUtils.min(eventStartDate, (LocalDate)scheduleEntity.getStartDate());
            eventEndDate = DateTimeUtils.max(eventEndDate, (LocalDate)scheduleEntity.getStartDate());
            if (scheduleEntity.getPrograms() != null) {
                for (ProgramEntity programEntity : scheduleEntity.getPrograms()) {
                    schdeduleStartTime = DateTimeUtils.min(schdeduleStartTime, (LocalTime)programEntity.getEndTime());
                    scheduleEndTime = DateTimeUtils.max(scheduleEndTime, (LocalTime)programEntity.getEndTime());
                    programEntity.setSchedule(scheduleEntity);
                }
                if (scheduleEntity.getStartTime() == null) {
                    scheduleEntity.setStartTime(schdeduleStartTime);
                }
                if (scheduleEntity.getEndTime() == null) {
                    scheduleEntity.setEndTime(scheduleEndTime);
                }
            }
            scheduleEntity.setEvent(eventEntity);
        }
        eventEntity.setStartDate(eventStartDate);
        eventEntity.setEndDate(eventEndDate);
    }

    @Generated
    public DefaultEventService(EventRepository eventRepository, EventMapper eventMapper, EventConductorRepository eventConductorRepository, EventConductorMapper eventConductorMapper, ScheduleRepository scheduleRepository, ScheduleMapper scheduleMapper, ProgramRepository programRepository, ProgramMapper programMapper, SubscribedParticipantRepository subscribedParticipantRepository, SubscribedParticipantMapper subscribedParticipantMapper, ArchivedEventRepository archivedEventRepository, ArchivedEventMapper archivedEventMapper, ArchivedSubscribedParticipantRepository archivedSubscribedParticipantRepository, ArchivedSubscribedParticipantMapper archivedSubscribedParticipantMapper) {
        this.eventRepository = eventRepository;
        this.eventMapper = eventMapper;
        this.eventConductorRepository = eventConductorRepository;
        this.eventConductorMapper = eventConductorMapper;
        this.scheduleRepository = scheduleRepository;
        this.scheduleMapper = scheduleMapper;
        this.programRepository = programRepository;
        this.programMapper = programMapper;
        this.subscribedParticipantRepository = subscribedParticipantRepository;
        this.subscribedParticipantMapper = subscribedParticipantMapper;
        this.archivedEventRepository = archivedEventRepository;
        this.archivedEventMapper = archivedEventMapper;
        this.archivedSubscribedParticipantRepository = archivedSubscribedParticipantRepository;
        this.archivedSubscribedParticipantMapper = archivedSubscribedParticipantMapper;
    }
}

