/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.validation;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.util.DateTimeUtils;
import com.finconsgroup.itserr.marketplace.event.dm.validation.annotation.ValidInputCreateOrUpdateEventDto;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class InputCreateOrUpdateEventDtoValidator
implements ConstraintValidator<ValidInputCreateOrUpdateEventDto, Object> {
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean valid = true;
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InputCreateEventDto.class, InputUpdateEventDto.class}, (Object)object, n)) {
            case -1: {
                return valid;
            }
            case 0: {
                InputCreateEventDto inputCreateEventDto = (InputCreateEventDto)object;
                valid = this.validateSchedules(context, inputCreateEventDto.getSchedules(), inputCreateEventDto.getEventConductors());
                break;
            }
            case 1: {
                InputUpdateEventDto inputUpdateEventDto = (InputUpdateEventDto)object;
                valid = this.validateSchedules(context, inputUpdateEventDto.getSchedules(), inputUpdateEventDto.getEventConductors());
                break;
            }
        }
        return valid;
    }

    private boolean validateSchedules(ConstraintValidatorContext context, List<InputScheduleDto> schedules, List<InputEventConductorDto> eventConductors) {
        boolean valid = true;
        LocalDate startDate = null;
        LocalDate endDate = null;
        HashSet eventConductorEmails = new HashSet();
        if (eventConductors != null) {
            eventConductors.stream().map(InputEventConductorDto::getEmail).filter(Objects::nonNull).forEach(eventConductorEmails::add);
        }
        if (schedules != null) {
            for (int i = 0; i < schedules.size(); ++i) {
                InputScheduleDto schedule = schedules.get(i);
                if (schedule == null) continue;
                startDate = DateTimeUtils.min(startDate, (LocalDate)schedule.getStartDate());
                endDate = DateTimeUtils.max(endDate, (LocalDate)schedule.getStartDate());
                if (schedule.getPrograms() == null) continue;
                for (int j = 0; j < schedule.getPrograms().size(); ++j) {
                    InputProgramDto program = (InputProgramDto)schedule.getPrograms().get(j);
                    if (program == null || program.getProgramConductors() == null) continue;
                    for (int k = 0; k < program.getProgramConductors().size(); ++k) {
                        if (eventConductorEmails.contains(program.getProgramConductors().get(k))) continue;
                        context.buildConstraintViolationWithTemplate("event_dm_program_conductor_not_in_event_conductors").addPropertyNode("schedules").inIterable().atIndex(Integer.valueOf(i)).addPropertyNode("programs").inIterable().atIndex(Integer.valueOf(j)).addPropertyNode("programConductors").inIterable().atIndex(Integer.valueOf(k)).addConstraintViolation();
                        valid = false;
                    }
                }
            }
            if (startDate == null) {
                context.buildConstraintViolationWithTemplate("event_dm_event_calculated_start_date_null").addConstraintViolation();
                valid = false;
            }
            if (endDate == null) {
                context.buildConstraintViolationWithTemplate("event_dm_event_calculated_end_date_null").addConstraintViolation();
                valid = false;
            }
        }
        return valid;
    }
}

