package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config = MapperConfiguration.class, uses = {ProgramConductorMapper.class})
public interface ProgramMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "programOrder", ignore = true)
    @Mapping(target = "schedule", ignore = true)
    @Mapping(target = "scheduleId", ignore = true)
    @Mapping(target = "subscribedParticipantsCount", ignore = true)
    @Mapping(target = "subscribedParticipants", ignore = true)
    ProgramEntity toEntity(InputProgramDto inputProgramDto);

    OutputProgramDto toDto(ProgramEntity programEntity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "programOrder", ignore = true)
    @Mapping(target = "schedule", ignore = true)
    @Mapping(target = "scheduleId", ignore = true)
    @Mapping(target = "subscribedParticipantsCount", ignore = true)
    @Mapping(target = "subscribedParticipants", ignore = true) // not updatable for event/program update
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputProgramDto dto, @MappingTarget ProgramEntity entity);

}
