package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.service.impl.DefaultEventService;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config = MapperConfiguration.class, uses = {ScheduleMapper.class, EventConductorMapper.class, SubscribedParticipantMapper.class})
public interface EventMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "eventPlannerId", ignore = true)
    @Mapping(target = "subscribedParticipantsCount", ignore = true)
    @Mapping(target = "startDate", ignore = true)
    @Mapping(target = "endDate", ignore = true)
    @Mapping(target = "maintainerId", ignore = true)
    @Mapping(target = "imageId", source = "image.id")
    @Mapping(target = "imageUrl", source = "image.url")
    @Mapping(target = "subscribedParticipants", ignore = true) // not insertable with for create event
    EventEntity toEntity(InputCreateEventDto inputCreateEventDto);

    @Mapping(target = "image.id", source = "imageId")
    @Mapping(target = "image.url", source = "imageUrl")
    @Mapping(target = "subscribed", ignore = true)
    OutputEventDto toDto(EventEntity eventEntity);

    @Mapping(target = "image.id", source = "eventEntity.imageId")
    @Mapping(target = "image.url", source = "eventEntity.imageUrl")
    @Mapping(target = "eventConductors", source = "associations.eventConductors")
    @Mapping(target = "schedules", source = "associations.schedules")
    @Mapping(target = "subscribedParticipants", source = "associations.subscribedParticipants")
    @Mapping(target = "subscribed", ignore = true)
    OutputEventDto toDtoWithAssociations(EventEntity eventEntity, DefaultEventService.Associations associations);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "eventPlannerId", ignore = true)
    @Mapping(target = "subscribedParticipantsCount", ignore = true)
    @Mapping(target = "startDate", ignore = true)
    @Mapping(target = "endDate", ignore = true)
    @Mapping(target = "maintainerId", ignore = true)
    @Mapping(target = "imageId", source = "image.id")
    @Mapping(target = "imageUrl", source = "image.url")
    @Mapping(target = "eventConductors", ignore = true) // will be set manually
    @Mapping(target = "schedules", ignore = true) // will be set manually
    @Mapping(target = "subscribedParticipants", ignore = true) // not updatable for event update
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputUpdateEventDto dto, @MappingTarget EventEntity entity);

}
