package com.finconsgroup.itserr.marketplace.favouritesearch.dm.converter;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

/**
 * Attribute Converter for handling conversion between {@link SearchContext} and {@link String}
 */
@Converter
public class SearchContextAttributeConverter implements AttributeConverter<SearchContext, String> {

    @Override
    public String convertToDatabaseColumn(SearchContext attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute.getId();
    }

    @Override
    public SearchContext convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return null;
        }

        return SearchContext.ofId(dbData);
    }
}
