package com.finconsgroup.itserr.marketplace.favouritesearch.dm.converter;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

/**
 * Converter class for converting from {@link String} to {@link SearchContext}.
 * Mostly used by the conversion for request parameters.
 */
public class StringToSearchContextConverter implements Converter<String, SearchContext> {
    @Override
    public SearchContext convert(@NonNull String source) {
        if (StringUtils.isBlank(source)) {
            return null;
        }

        return SearchContext.ofId(source.toLowerCase());
    }
}
