/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.SearchFilterFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="InputCreateFavouriteSearch", description="DTO for creating a favouriteSearch")
public class InputCreateFavouriteSearchDto {
    @Schema(description="The name of the favourite search", example="My favourite search")
    @NotBlank(message="required field")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @NotBlank(message="required field") @Size(max=255, message="field length must be between {min} and {max}") String name;
    @Schema(description="The context of the favourite search", example="items")
    @NotNull(message="required field")
    private @NotNull(message="required field") SearchContext context;
    @Schema(description="The text used to perform the search", example="Godfath")
    @NotBlank(message="required field")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @NotBlank(message="required field") @Size(max=255, message="field length must be between {min} and {max}") String searchText;
    @Schema(description="Raw filters of the search provided by the frontend")
    private List<@Valid SearchFilterFavouriteSearchDto> searchFilters;

    @Generated
    public static InputCreateFavouriteSearchDtoBuilder builder() {
        return new InputCreateFavouriteSearchDtoBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SearchContext getContext() {
        return this.context;
    }

    @Generated
    public String getSearchText() {
        return this.searchText;
    }

    @Generated
    public List<@Valid SearchFilterFavouriteSearchDto> getSearchFilters() {
        return this.searchFilters;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setContext(SearchContext context) {
        this.context = context;
    }

    @Generated
    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Generated
    public void setSearchFilters(List<@Valid SearchFilterFavouriteSearchDto> searchFilters) {
        this.searchFilters = searchFilters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateFavouriteSearchDto)) {
            return false;
        }
        InputCreateFavouriteSearchDto other = (InputCreateFavouriteSearchDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SearchContext this$context = this.getContext();
        SearchContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$searchText = this.getSearchText();
        String other$searchText = other.getSearchText();
        if (this$searchText == null ? other$searchText != null : !this$searchText.equals(other$searchText)) {
            return false;
        }
        List this$searchFilters = this.getSearchFilters();
        List other$searchFilters = other.getSearchFilters();
        return !(this$searchFilters == null ? other$searchFilters != null : !((Object)this$searchFilters).equals(other$searchFilters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateFavouriteSearchDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SearchContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $searchText = this.getSearchText();
        result = result * 59 + ($searchText == null ? 43 : $searchText.hashCode());
        List $searchFilters = this.getSearchFilters();
        result = result * 59 + ($searchFilters == null ? 43 : ((Object)$searchFilters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateFavouriteSearchDto(name=" + this.getName() + ", context=" + String.valueOf(this.getContext()) + ", searchText=" + this.getSearchText() + ", searchFilters=" + String.valueOf(this.getSearchFilters()) + ")";
    }

    @Generated
    public InputCreateFavouriteSearchDto(String name, SearchContext context, String searchText, List<@Valid SearchFilterFavouriteSearchDto> searchFilters) {
        this.name = name;
        this.context = context;
        this.searchText = searchText;
        this.searchFilters = searchFilters;
    }
}

