package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties for messaging.
 */
@Data
@Validated
@ConfigurationProperties(prefix = "favourite-user.bs.messaging")
public class MessagingConfigurationProperties {

    /**
     * Name of the configured producer
     */
    @NotBlank
    private String producerName;

    /**
     * Name of the configured event producer
     */
    @NotBlank
    private String eventProducerName;

    /**
     * Source identifier for events, used to indicate the origin of a message.
     */
    @NotBlank
    private String source;

    /**
     * Event type string used for favourite item creation events.
     */
    @NotBlank
    private String favouriteItemCreatedEventType;

    /**
     * Event type string used for favourite item update events.
     */
    @NotBlank
    private String favouriteItemUpdatedEventType;

    /**
     * Event type string used for favourite item deletion events.
     */
    @NotBlank
    private String favouriteItemDeletedEventType;

    /**
     * Event type string used for catalog item created by followee (researcher followed by other users).
     */
    @NotBlank
    private String favouriteItemFolloweeCatalogCreatedEventType;

    /**
     * Event type string used for institutional page created by followee (researcher followed by other users).
     */
    @NotBlank
    private String favouriteItemFolloweeInstitutionalPageCreatedEventType;

    /**
     * Event type string used for event created by followee (researcher followed by other users).
     */
    @NotBlank
    private String favouriteItemFolloweeEventCreatedEventType;

    /**
     * Event type string used for news created by followee (researcher followed by other users).
     */
    @NotBlank
    private String favouriteItemFolloweeNewsCreatedEventType;

}
