package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * Favourite item message body.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@ToString(callSuper = true)
public class FavouriteItemMessageBodyDto
        extends MessagingEventDto<FavouriteItemMessageBodyDto.AdditionalData> {

    /**
     * Additional data for favourite item event.
     */
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AdditionalData {

        /** Referenced item id. */
        private String itemId;

        /** Referenced item name. */
        private String itemName;

        /** Referenced item title. */
        private String itemTitle;

        /** Followed flag. */
        private Boolean followed;

        /** The users a notification should be sent to. */
        private List<String> notifyUserIds;

    }

}
