package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.ResourceByFolloweeMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.FavouriteItemMessageBodyDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link EventProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Slf4j
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
public class LoggerEventProducer implements EventProducer {

    @Override
    public void publishFavouriteItemCreatedEvent(@NonNull final FavouriteItemMessageBodyDto favouriteItem) {
        log.info("Message dispatch skipped (local profile) - Created event for favourite item: {}", favouriteItem);
    }

    @Override
    public void publishFavouriteItemUpdatedEvent(@NonNull final FavouriteItemMessageBodyDto favouriteItem) {
        log.info("Message dispatch skipped (local profile) - Updated event for favourite item: {}", favouriteItem);
    }

    @Override
    public void publishFavouriteItemDeletedEvent(@NonNull final FavouriteItemMessageBodyDto favouriteItem) {
        log.info("Message dispatch skipped (local profile) - Deleted event for favourite item: {}", favouriteItem);
    }

    @Override
    public void publishResourceCreatedByFolloweeEvent(@NonNull ResourceByFolloweeMessageBodyDto resourceByFollowee) {
        log.info("Message dispatch skipped (local profile) - Resource created by followee event: {}", resourceByFollowee);
    }
}
