package com.finconsgroup.itserr.marketplace.favourite.user.bs.service;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * Interface that should be implemented by service for each type of favourite items to provide details
 *
 * @param <T> the type of result
 */
public interface FavouriteUserItemDetailProvider<T extends FavouriteUserItemDetail> {

    /**
     * Returns the filters that need to be applied on the provider side.
     *
     * @param filters the filters string to be applied
     * @return the list of applicable {@link DetailRequest.Filter}
     */
    @NonNull
    List<DetailRequest.Filter> getApplicableFilters(String filters);

    /**
     * Fetch the details for requested item for provided itemId.
     *
     * @param itemId the id of the item to fetch details for
     * @return the item details result
     */
    @NonNull
    T getDetailById(@NonNull String itemId);

    /**
     * Fetch the details for requested items applying the filters and page request.
     *
     * @param request the get items request with necessary details
     * @return page containing the item details results
     */
    @NonNull
    OutputPageDto<T> getDetails(@NonNull DetailRequest request);
}
