package com.finconsgroup.itserr.marketplace.favourite.user.bs.service;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import org.springframework.lang.NonNull;

import java.util.Optional;

/**
 * Interface for registry of favourite user item details providers
 */
public interface FavouriteUserItemDetailProviderRegistry {
    /**
     * Register the favourite user item detail provider for the item context.
     * If there was another provider already registered for the same item context, it replaces the same.
     *
     * @param itemContext the {@link ItemContext} to register for
     * @param favouriteUserItemDetailProvider the {@link FavouriteUserItemDetailProvider} to register
     * @param <T> the type of favourite user item detail result
     */
    <T extends FavouriteUserItemDetail> void register(@NonNull ItemContext itemContext,
                                                      @NonNull FavouriteUserItemDetailProvider<T> favouriteUserItemDetailProvider);

    /**
     * Returns the favourite user item detail provider for the item context.
     *
     * @param itemContext the {@link ItemContext} to retrieve the provider for
     * @return an Optional with {@link FavouriteUserItemDetailProvider} if registered, otherwise empty
     * @param <T> the type of favourite user item detail result
     */
    @NonNull
    <T extends FavouriteUserItemDetail> Optional<FavouriteUserItemDetailProvider<T>> getProvider(@NonNull ItemContext itemContext);
}
