package com.finconsgroup.itserr.marketplace.favourite.user.bs.config;

import com.finconsgroup.itserr.marketplace.core.web.bean.FilterProperties;
import com.finconsgroup.itserr.marketplace.core.web.validation.QueryFilterValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * Configuration class for any custom filter related configuration.
 */
@Configuration
public class FavouriteUserFilterConfiguration {

    /**
     * Defines the filter properties map bean needed by the {@link QueryFilterValidator}
     *
     * @param favouriteUserBsProperties the application configuration
     * @return the map filter properties for default key
     */
    @Bean(QueryFilterValidator.FILTER_PROPERTY_MAP_BEAN_NAME)
    public Map<String, FilterProperties> filterPropertyMap(FavouriteUserBsProperties favouriteUserBsProperties) {
        return Map.of(QueryFilterValidator.DEFAULT_CONFIG_KEY, favouriteUserBsProperties.filter());
    }
}
