package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.UUID;

/**
 * Resource created by followee message body.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@ToString(callSuper = true)
public class ResourceByFolloweeMessageBodyDto
        extends MessagingEventDto<ResourceByFolloweeMessageBodyDto.AdditionalData> {

    /**
     * Additional data for resource created by followee e.g. catalog item, institutional page etc..
     */
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AdditionalData {

        /** The item context indicating the type of the resource created */
        private String itemContext;

        /** The id of the user who created the resource */
        private UUID followeeId;

        /** The preferred username of the user who created the resource */
        private String followeeUsername;

        /** The name of the user who created the resource */
        private String followeeName;

        /** The users a notification should be sent to i.e. the followers. */
        private List<String> notifyUserIds;

    }

}
