/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.dto.PageRequestDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.FavouriteUserDmClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputFindFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDetailDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemSubscriberDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.InputFindUserProfilesByTokenInfoDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.FavouriteItemMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.ResourceByFolloweeMessageBodyDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.helper.MessagingHelper;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProvider;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProviderRegistry;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemService;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import io.micrometer.common.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultFavouriteUserItemService
implements FavouriteUserItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFavouriteUserItemService.class);
    private static final String USER_DM_DEFAULT_SORT_FIELD = "id";
    public static final Set<String> USER_DM_SORT_FIELDS = Set.of("id", "context", "subContext", "itemId", "creationTime", "updateTime");
    private static final int FETCH_ALL_PAGE_SIZE = 200;
    private final FavouriteUserDmClient favouriteUserDmClient;
    private final UserProfileDmClient userProfileDmClient;
    private final FavouriteUserItemDetailProviderRegistry favouriteUserItemDetailProviderRegistry;
    private final MessagingHelper messagingHelper;
    private final EventProducer eventProducer;

    @NonNull
    public OutputFavouriteUserItemDto create(@NonNull InputCreateFavouriteUserItemDto dto) {
        OutputFavouriteUserItemDto favouriteItem = this.favouriteUserDmClient.create(dto);
        FavouriteItemMessageBodyDto message = this.messagingHelper.buildFavouriteItemMessage(favouriteItem);
        this.eventProducer.publishFavouriteItemCreatedEvent(message);
        return favouriteItem;
    }

    @NonNull
    public <T extends FavouriteUserItemDetail> OutputFavouriteUserItemDetailDto<T> findById(@NonNull UUID favouriteUserItemId) {
        OutputFavouriteUserItemDto outputFavouriteUserItemDto = this.favouriteUserDmClient.get(favouriteUserItemId);
        return this.getDetailForItem(outputFavouriteUserItemDto);
    }

    @NonNull
    private <T extends FavouriteUserItemDetail> OutputFavouriteUserItemDetailDto<T> getDetailForItem(OutputFavouriteUserItemDto outputFavouriteUserItemDto) {
        ItemContext context = outputFavouriteUserItemDto.getContext();
        FavouriteUserItemDetailProvider detailProvider = this.getDetailProvider(context);
        OutputFavouriteUserItemDetailDto outputFavouriteUserItemDetailDto = this.buildFavouriteUserItemDetailDto(outputFavouriteUserItemDto);
        FavouriteUserItemDetail itemDetail = detailProvider.getDetailById(outputFavouriteUserItemDto.getItemId());
        outputFavouriteUserItemDetailDto.setItemDetail((Object)itemDetail);
        return outputFavouriteUserItemDetailDto;
    }

    public void deleteById(@NonNull UUID favouriteUserItemId) {
        OutputFavouriteUserItemDto favouriteItem = this.favouriteUserDmClient.get(favouriteUserItemId);
        this.favouriteUserDmClient.delete(favouriteUserItemId);
        FavouriteItemMessageBodyDto message = this.messagingHelper.buildFavouriteItemMessage(favouriteItem);
        this.eventProducer.publishFavouriteItemDeletedEvent(message);
    }

    @NonNull
    public OutputFavouriteUserItemDto patchById(@NonNull UUID favouriteUserItemId, @NonNull InputPatchFavouriteUserItemDto dto) {
        OutputFavouriteUserItemDto updatedFavouriteItem = this.favouriteUserDmClient.patch(favouriteUserItemId, dto);
        FavouriteItemMessageBodyDto message = this.messagingHelper.buildFavouriteItemMessage(updatedFavouriteItem);
        this.eventProducer.publishFavouriteItemUpdatedEvent(message);
        return updatedFavouriteItem;
    }

    @NonNull
    public <T extends FavouriteUserItemDetail> OutputPageDto<OutputFavouriteUserItemDetailDto<T>> findByContext(@NonNull InputFindFavouriteUserItemDto dto) {
        ItemContext context = dto.getContext();
        FavouriteUserItemDetailProvider detailProvider = this.getDetailProvider(context);
        List detailProviderFilters = detailProvider.getApplicableFilters(dto.getFilters());
        if (this.isSupportedUserDomainServiceSort(dto.getSort()) && detailProviderFilters.isEmpty()) {
            return this.findByContextWithSortFiltersOnUserDmService(dto, detailProvider);
        }
        return this.findByContextWithSortFiltersOnDetailProvider(dto, detailProvider, detailProviderFilters);
    }

    @NonNull
    public List<OutputFavouriteUserItemDto> findByContextAndItemIds(@NonNull ItemContext context, String subContext, @NonNull String itemIds, String itemIdSeparator) {
        return this.favouriteUserDmClient.findByContextAndItemIds(context.getId(), subContext, itemIds, itemIdSeparator);
    }

    public void deleteByContextAndItemId(@NonNull ItemContext context, String subContext, @NonNull String itemId, MessagingEventUserDto messagingEventUserDto) {
        log.info("Deleting all user favourites for item with context: {}, subContext: {} and id: {}", new Object[]{context, subContext, itemId});
        List deletedFavouriteItemDtos = this.favouriteUserDmClient.deleteByContextAndItemId(context.getId(), subContext, itemId);
        deletedFavouriteItemDtos.forEach(dto -> {
            FavouriteItemMessageBodyDto message = this.messagingHelper.buildFavouriteItemMessage(dto);
            if (messagingEventUserDto != null && (message.getUser() == null || message.getUser().getId() == null)) {
                message.setUser(messagingEventUserDto);
            }
            this.eventProducer.publishFavouriteItemDeletedEvent(message);
        });
    }

    public void publishResourceCreatedByFolloweeEvent(@NonNull String context, @NonNull String followeeRef, @NonNull MessagingEventDto<?> resourceEventDto) {
        List userProfileDtos = this.userProfileDmClient.findAllByTokenInfo(InputFindUserProfilesByTokenInfoDto.builder().tokenInfos(List.of(followeeRef)).build());
        if (userProfileDtos == null || userProfileDtos.isEmpty()) {
            log.info("No user profile found for followee reference: {}", (Object)followeeRef);
            return;
        }
        OutputUserProfileDto followee = (OutputUserProfileDto)userProfileDtos.getFirst();
        List<OutputFavouriteUserItemSubscriberDto> followingUsers = this.getAllSubscribers(ItemContext.PEOPLE, null, followee.getId().toString()).stream().filter(OutputFavouriteUserItemDto::isFollowed).toList();
        if (followingUsers.isEmpty()) {
            log.info("No users following the followee: {}", (Object)followee.getId());
            return;
        }
        ResourceByFolloweeMessageBodyDto messagingEventDto = new ResourceByFolloweeMessageBodyDto();
        messagingEventDto.setId(resourceEventDto.getId());
        messagingEventDto.setUser(resourceEventDto.getUser());
        messagingEventDto.setName(resourceEventDto.getName());
        messagingEventDto.setTitle(resourceEventDto.getTitle());
        messagingEventDto.setCategory(resourceEventDto.getCategory());
        messagingEventDto.setStatus(resourceEventDto.getStatus());
        messagingEventDto.setMessage(resourceEventDto.getMessage());
        messagingEventDto.setTimestamp(resourceEventDto.getTimestamp());
        ResourceByFolloweeMessageBodyDto.AdditionalData additionalData = ResourceByFolloweeMessageBodyDto.AdditionalData.builder().itemContext(context).followeeId(followee.getId()).followeeUsername(followee.getPreferredUsername()).followeeName(followee.getName()).notifyUserIds(followingUsers.stream().map(dto -> dto.getUserId().toString()).toList()).build();
        messagingEventDto.setAdditionalData((Object)additionalData);
        this.eventProducer.publishResourceCreatedByFolloweeEvent(messagingEventDto);
    }

    private <T extends FavouriteUserItemDetail> OutputPageDto<OutputFavouriteUserItemDetailDto<T>> findByContextWithSortFiltersOnUserDmService(@NonNull InputFindFavouriteUserItemDto dto, @NonNull FavouriteUserItemDetailProvider<T> detailProvider) {
        OutputPageDto favouriteItemsPage = this.favouriteUserDmClient.findByContext(dto.getContext().getId(), dto.getSubContext(), dto.getPageNumber(), dto.getPageSize(), dto.getSort(), dto.getDirection().name());
        if (favouriteItemsPage.getContent().isEmpty()) {
            return OutputPageDto.emptyWithPage((OutputPageDto.Page)favouriteItemsPage.getPage());
        }
        List<String> itemIds = favouriteItemsPage.getContent().stream().map(OutputFavouriteUserItemDto::getItemId).toList();
        OutputPageDto outputDetailPageDto = detailProvider.getDetails(DetailRequest.builder().itemContext(dto.getContext()).itemIds(itemIds).pageRequestDto(PageRequestDto.builder().pageNumber(0).pageSize(itemIds.size()).build()).build());
        Map itemDetailByItemId = outputDetailPageDto.getContent().stream().collect(Collectors.toMap(FavouriteUserItemDetail::getItemId, Function.identity()));
        ArrayList outputFavouriteUserItemDetailList = new ArrayList();
        favouriteItemsPage.getContent().forEach(favouriteUserItemDto -> {
            OutputFavouriteUserItemDetailDto outputFavouriteUserItemDetailDto = this.buildFavouriteUserItemDetailDto(favouriteUserItemDto);
            outputFavouriteUserItemDetailDto.setItemDetail((Object)((FavouriteUserItemDetail)itemDetailByItemId.get(favouriteUserItemDto.getItemId())));
            outputFavouriteUserItemDetailList.add(outputFavouriteUserItemDetailDto);
        });
        return OutputPageDto.builder().content(outputFavouriteUserItemDetailList).page(favouriteItemsPage.getPage()).build();
    }

    private <T extends FavouriteUserItemDetail> OutputPageDto<OutputFavouriteUserItemDetailDto<T>> findByContextWithSortFiltersOnDetailProvider(@NonNull InputFindFavouriteUserItemDto dto, @NonNull FavouriteUserItemDetailProvider<T> detailProvider, @NonNull List<DetailRequest.Filter> detailProviderFilters) {
        List items = this.getAllFavouriteItems(dto.getContext(), dto.getSubContext());
        if (items.isEmpty()) {
            return OutputPageDto.emptyWithPageSize((int)dto.getPageSize());
        }
        ArrayList itemIds = new ArrayList();
        HashMap favouriteUserItemDetailDtoByItemId = new HashMap();
        items.forEach(item -> {
            itemIds.add(item.getItemId());
            favouriteUserItemDetailDtoByItemId.put(item.getItemId(), this.buildFavouriteUserItemDetailDto(item));
        });
        String sort = "";
        if (StringUtils.isNotBlank((String)dto.getSort()) && dto.getSort().startsWith("itemDetail.")) {
            sort = dto.getSort().substring("itemDetail.".length());
        }
        OutputPageDto outputDetailPageDto = detailProvider.getDetails(DetailRequest.builder().itemContext(dto.getContext()).itemIds(itemIds).filters(detailProviderFilters).pageRequestDto(PageRequestDto.builder().pageNumber(dto.getPageNumber()).pageSize(dto.getPageSize()).sort(sort).direction(dto.getDirection()).build()).build());
        ArrayList outputFavouriteUserItemDetailList = new ArrayList();
        outputDetailPageDto.getContent().forEach(itemDetailDto -> {
            OutputFavouriteUserItemDetailDto outputFavouriteUserItemDetailDto = (OutputFavouriteUserItemDetailDto)favouriteUserItemDetailDtoByItemId.get(itemDetailDto.getItemId());
            outputFavouriteUserItemDetailDto.setItemDetail(itemDetailDto);
            outputFavouriteUserItemDetailList.add(outputFavouriteUserItemDetailDto);
        });
        return OutputPageDto.builder().content(outputFavouriteUserItemDetailList).page(outputDetailPageDto.getPage()).build();
    }

    @NonNull
    private List<OutputFavouriteUserItemDto> getAllFavouriteItems(@NonNull ItemContext context, String subContext) {
        return this.getAllPagedData(pageNumber -> this.favouriteUserDmClient.findByContext(context.getId(), subContext, pageNumber, 200, USER_DM_DEFAULT_SORT_FIELD, SortDirection.ASC.name()));
    }

    @NonNull
    private List<OutputFavouriteUserItemSubscriberDto> getAllSubscribers(@NonNull ItemContext context, String subContext, @NonNull String itemId) {
        return this.getAllPagedData(pageNumber -> this.favouriteUserDmClient.findSubscribers(context.getId(), subContext, itemId, pageNumber, 200, USER_DM_DEFAULT_SORT_FIELD, Sort.Direction.ASC));
    }

    @NonNull
    private <T> List<T> getAllPagedData(@NonNull IntFunction<OutputPageDto<T>> pageSupplierByPageNumber) {
        int pageNumber = 0;
        ArrayList itemDtos = new ArrayList();
        while (true) {
            OutputPageDto<T> favouriteItemsPage = pageSupplierByPageNumber.apply(pageNumber);
            itemDtos.addAll(favouriteItemsPage.getContent());
            if (favouriteItemsPage.getContent().isEmpty() || (long)itemDtos.size() >= favouriteItemsPage.getPage().getTotalElements() || favouriteItemsPage.getContent().size() < 200) break;
            ++pageNumber;
        }
        return itemDtos;
    }

    private <T extends FavouriteUserItemDetail> FavouriteUserItemDetailProvider<T> getDetailProvider(@NonNull ItemContext context) {
        FavouriteUserItemDetailProvider detailProvider = (FavouriteUserItemDetailProvider)this.favouriteUserItemDetailProviderRegistry.getProvider(context).orElseThrow(() -> new WP2BusinessException("Detail provider not found for " + context.getId()));
        return detailProvider;
    }

    private <T extends FavouriteUserItemDetail> OutputFavouriteUserItemDetailDto<T> buildFavouriteUserItemDetailDto(OutputFavouriteUserItemDto itemDto) {
        return ((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)((OutputFavouriteUserItemDetailDto.OutputFavouriteUserItemDetailDtoBuilder)OutputFavouriteUserItemDetailDto.detailBuilder().id(itemDto.getId())).context(itemDto.getContext())).subContext(itemDto.getSubContext())).itemId(itemDto.getItemId())).followed(itemDto.isFollowed())).creationTime(itemDto.getCreationTime())).updateTime(itemDto.getUpdateTime())).build();
    }

    private boolean isSupportedUserDomainServiceSort(String sort) {
        return StringUtils.isBlank((String)sort) || USER_DM_SORT_FIELDS.contains(sort);
    }

    @Generated
    public DefaultFavouriteUserItemService(FavouriteUserDmClient favouriteUserDmClient, UserProfileDmClient userProfileDmClient, FavouriteUserItemDetailProviderRegistry favouriteUserItemDetailProviderRegistry, MessagingHelper messagingHelper, EventProducer eventProducer) {
        this.favouriteUserDmClient = favouriteUserDmClient;
        this.userProfileDmClient = userProfileDmClient;
        this.favouriteUserItemDetailProviderRegistry = favouriteUserItemDetailProviderRegistry;
        this.messagingHelper = messagingHelper;
        this.eventProducer = eventProducer;
    }
}

