package com.finconsgroup.itserr.marketplace.favourite.user.bs.client;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.catalog.OutputItemDto;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * Client interface for interacting with the Catalog Business Service.
 */
public interface CatalogBsClient {

    /**
     * Retrieves a catalog item by its id.
     *
     * @param id the id of the catalog item to retrieve
     * @return the catalog item details
     */
    @GetMapping(path = "/catalog/items/{id}")
    OutputItemDto getItemById(
            @PathVariable(name = "id") String id);

}
