package com.finconsgroup.itserr.marketplace.favourite.user.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.api.FavouriteUserItemApi;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputFindFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDetailDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.UUID;

/**
 * Spring Boot REST Controller implementation for the {@link FavouriteUserItemApi} endpoints.
 */
@RestController
@RequiredArgsConstructor
@Slf4j
public class FavouriteUserItemController implements FavouriteUserItemApi {

    private final FavouriteUserItemService favouriteUserItemService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        // trim strings before triggering validation, but do not convert to null
        // as otherwise it throws - MissingServletRequestParameterException
        binder.registerCustomEditor(String.class, new StringTrimmerEditor(false));
    }

    @NonNull
    @Override
    public OutputFavouriteUserItemDto create(InputCreateFavouriteUserItemDto dto) {
        return favouriteUserItemService.create(dto);
    }

    @NonNull
    @Override
    public OutputFavouriteUserItemDetailDto<?> get(UUID favouriteUserItemId) {
        return favouriteUserItemService.findById(favouriteUserItemId);
    }

    @Override
    public void delete(UUID favouriteUserItemId) {
        favouriteUserItemService.deleteById(favouriteUserItemId);
    }

    @Override
    public OutputFavouriteUserItemDto patch(UUID favouriteUserItemId, InputPatchFavouriteUserItemDto dto) {
        return favouriteUserItemService.patchById(favouriteUserItemId, dto);
    }

    @NonNull
    @Override
    public OutputPageDto<OutputFavouriteUserItemDetailDto<FavouriteUserItemDetail>> findByContext(
        ItemContext context, String subContext, int pageNumber, int pageSize, String sort, SortDirection direction,
        String filters) {
        InputFindFavouriteUserItemDto dto = InputFindFavouriteUserItemDto
                                                .builder()
                                                .context(context)
                                                .subContext(subContext)
                                                .pageNumber(pageNumber)
                                                .pageSize(pageSize)
                                                .sort(sort)
                                                .direction(direction).filters(filters)
                                                .build();
        return favouriteUserItemService.findByContext(dto);
    }

    @Override
    public List<OutputFavouriteUserItemDto> findByContextAndItemIds(ItemContext context, String subContext,
                                                                    String itemIds, String itemIdSeparator) {
        return favouriteUserItemService.findByContextAndItemIds(context, subContext, itemIds, itemIdSeparator);
    }
}
