package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Find Favourite User Items for context request dto.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InputFindFavouriteUserItemDto {

    /**
     * The {@link ItemContext} to search favourite user items for
     */
    private ItemContext context;

    /**
     * The sub context to search favourite user items for
     */
    private String subContext;

    /**
     * The page number to retrieve (default is 0)
     */
    @Builder.Default
    private int pageNumber = 0;

    /**
     * The number of favourite user item per page (default is 10)
     */
    @Builder.Default
    private int pageSize = 10;

    /**
     * The field to sort by (default is "id")
     */
    @Builder.Default
    private String sort = "id";

    /**
     * The direction of sorting (default is ascending)
     */
    @Builder.Default
    private SortDirection direction = SortDirection.ASC;

    /**
     * The filters to apply if any (optional)
     */
    private String filters;
}
