package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.MessagingEventBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.EventCreatedMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component("eventEventConsumer")
@Slf4j
public class EventEventConsumer extends CloudEventConsumer {

    private final FavouriteUserItemService favouriteUserItemService;

    /**
     * Constructs the EventEventConsumer
     *
     * @param favouriteUserBsConfigurationProperties the application configuration properties
     * @param favouriteUserItemService               favourite user item service
     */
    public EventEventConsumer(FavouriteUserBsProperties favouriteUserBsConfigurationProperties,
                              FavouriteUserItemService favouriteUserItemService) {
        MessagingEventBsProperties messagingEventBsProperties = favouriteUserBsConfigurationProperties.messaging().getEventBs();
        addHandler(messagingEventBsProperties.getResourceCreatedEventType(), new TypeReference<>() {
                },
                this::handleResourceCreated);

        this.favouriteUserItemService = favouriteUserItemService;
    }

    private void handleResourceCreated(MessagingEventDto<EventCreatedMessagingAdditionalDataDto> eventPayload,
                                       CloudEvent cloudEvent) {
        favouriteUserItemService.publishResourceCreatedByFolloweeEvent(ItemContext.EVENT_ID,
                eventPayload.getUser().getId().toString(), eventPayload);
    }

}