package com.finconsgroup.itserr.marketplace.favourite.user.dm.mapper;

import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemSubscriberDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.entity.FavouriteUserItemEntity;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Mapper for all dto/entity conversions related to {@link FavouriteUserItemEntity}
 */
@Mapper(config = MapperConfiguration.class)
public interface FavouriteUserItemMapper {

    /**
     * Maps a {@link InputCreateFavouriteUserItemDto} to a {@link FavouriteUserItemEntity}
     *
     * @param dto the source dto
     * @return the mapped entity
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    FavouriteUserItemEntity createDtoToEntity(@NonNull InputCreateFavouriteUserItemDto dto, @NonNull UUID userId);

    /**
     * Maps the {@link InputPatchFavouriteUserItemDto} to the target {@link FavouriteUserItemEntity}
     *
     * @param entity the mapped entity
     * @param dto the source dto
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "userId", ignore = true)
    @Mapping(target = "context", ignore = true)
    @Mapping(target = "subContext", ignore = true)
    @Mapping(target = "itemId", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void patchDtoToEntity(@MappingTarget @NonNull FavouriteUserItemEntity entity, @NonNull InputPatchFavouriteUserItemDto dto);

    /**
     * Maps a {@link FavouriteUserItemEntity} to an {@link OutputFavouriteUserItemDto}
     *
     * @param entity the source entity
     * @return the mapped dto
     */
    OutputFavouriteUserItemDto toOutputDto(@NonNull FavouriteUserItemEntity entity);

    /**
     * Maps a {@link FavouriteUserItemEntity} to an {@link OutputFavouriteUserItemSubscriberDto}
     *
     * @param entity the source entity
     * @return the mapped dto
     */
    OutputFavouriteUserItemSubscriberDto toOutputSubscriberDto(@NonNull FavouriteUserItemEntity entity);
}
