/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemSubscriberDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.entity.ArchivedFavouriteUserItemEntity;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.entity.FavouriteUserItemEntity;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.mapper.ArchivedFavouriteUserItemMapper;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.mapper.FavouriteUserItemMapper;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.repository.ArchivedFavouriteUserItemRepository;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.repository.FavouriteUserItemRepository;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.service.FavouriteUserItemService;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultFavouriteUserItemService
implements FavouriteUserItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFavouriteUserItemService.class);
    private static final String FORMAT_BUSINESS_KEY = "{context: %s, itemId: %s}";
    private final FavouriteUserItemRepository favouriteUserItemRepository;
    private final FavouriteUserItemMapper favouriteUserItemMapper;
    private final ArchivedFavouriteUserItemRepository archivedFavouriteUserItemRepository;
    private final ArchivedFavouriteUserItemMapper archivedFavouriteUserItemMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputFavouriteUserItemDto create(@NonNull UUID userId, @NonNull InputCreateFavouriteUserItemDto dto) {
        if (this.favouriteUserItemRepository.countByUserIdAndContextAndItemId(userId, dto.getContext(), dto.getItemId()) > 0) {
            throw new WP2DuplicateResourceException(FORMAT_BUSINESS_KEY.formatted(dto.getContext(), dto.getItemId()));
        }
        FavouriteUserItemEntity favouriteUserItemEntity = this.favouriteUserItemMapper.createDtoToEntity(dto, userId);
        return this.saveAndReturnDto(favouriteUserItemEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputFavouriteUserItemDto findById(@NonNull UUID userId, @NonNull UUID favouriteUserItemId) {
        FavouriteUserItemEntity favouriteUserItemEntity = this.findByIdOrThrow(userId, favouriteUserItemId);
        return this.favouriteUserItemMapper.toOutputDto(favouriteUserItemEntity);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NonNull UUID userId, @NonNull UUID favouriteUserItemId) {
        FavouriteUserItemEntity favouriteUserItemEntity = this.findByIdOrThrow(userId, favouriteUserItemId);
        this.deleteEntity(favouriteUserItemEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputFavouriteUserItemDto patchById(@NonNull UUID userId, @NonNull UUID favouriteUserItemId, @NonNull InputPatchFavouriteUserItemDto dto) {
        FavouriteUserItemEntity favouriteUserItemEntity = this.findByIdOrThrow(userId, favouriteUserItemId);
        this.favouriteUserItemMapper.patchDtoToEntity(favouriteUserItemEntity, dto);
        return this.saveAndReturnDto(favouriteUserItemEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputFavouriteUserItemDto> findByContext(@NonNull UUID userId, @NonNull ItemContext context, String subContext, @NonNull Pageable pageable) {
        Page favouriteUserItemEntitiesResult = StringUtils.isNotBlank((CharSequence)subContext) ? this.favouriteUserItemRepository.findByUserIdAndContextAndSubContext(userId, context, subContext, pageable) : this.favouriteUserItemRepository.findByUserIdAndContext(userId, context, pageable);
        return favouriteUserItemEntitiesResult.map(arg_0 -> ((FavouriteUserItemMapper)this.favouriteUserItemMapper).toOutputDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public List<OutputFavouriteUserItemDto> findByContextAndItemIds(@NonNull UUID userId, @NonNull ItemContext context, String subContext, @NonNull Set<String> itemIds) {
        if (itemIds.isEmpty()) {
            return List.of();
        }
        List favouriteUserItemEntities = StringUtils.isNotBlank((CharSequence)subContext) ? this.favouriteUserItemRepository.findByUserIdAndContextAndSubContextAndItemIdIn(userId, context, subContext, itemIds) : this.favouriteUserItemRepository.findByUserIdAndContextAndItemIdIn(userId, context, itemIds);
        return favouriteUserItemEntities.stream().map(arg_0 -> ((FavouriteUserItemMapper)this.favouriteUserItemMapper).toOutputDto(arg_0)).toList();
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputFavouriteUserItemSubscriberDto> findSubscribers(@NonNull ItemContext context, String subContext, @NonNull String itemId, @NonNull Pageable pageable) {
        String subContextFilter = StringUtils.isBlank((CharSequence)subContext) ? null : subContext;
        return this.favouriteUserItemRepository.findByContextAndItemIdAndFollowedIsTrueAndOptionalSubContext(context, itemId, subContextFilter, pageable).map(arg_0 -> ((FavouriteUserItemMapper)this.favouriteUserItemMapper).toOutputSubscriberDto(arg_0));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public List<OutputFavouriteUserItemDto> deleteByContextAndItemId(@NonNull ItemContext context, String subContext, @NonNull String itemId) {
        String subContextFilter = StringUtils.isBlank((CharSequence)subContext) ? null : subContext;
        LinkedList<OutputFavouriteUserItemDto> deletedFavouriteItemDtos = new LinkedList<OutputFavouriteUserItemDto>();
        this.favouriteUserItemRepository.findAllByContextAndItemIdAndOptionalSubContext(context, itemId, subContextFilter).forEach(entity -> {
            deletedFavouriteItemDtos.add(this.favouriteUserItemMapper.toOutputDto(entity));
            this.deleteEntity(entity);
        });
        return deletedFavouriteItemDtos;
    }

    private FavouriteUserItemEntity findByIdOrThrow(@NonNull UUID userId, @NonNull UUID favouriteUserItemId) {
        return (FavouriteUserItemEntity)this.favouriteUserItemRepository.findByUserIdAndId(userId, favouriteUserItemId).orElseThrow(() -> new WP2ResourceNotFoundException(favouriteUserItemId));
    }

    private OutputFavouriteUserItemDto saveAndReturnDto(@NonNull FavouriteUserItemEntity favouriteUserItemEntity) {
        FavouriteUserItemEntity savedFavouriteUserItemEntity = (FavouriteUserItemEntity)this.favouriteUserItemRepository.save((Object)favouriteUserItemEntity);
        return this.favouriteUserItemMapper.toOutputDto(savedFavouriteUserItemEntity);
    }

    private void deleteEntity(@NonNull FavouriteUserItemEntity favouriteUserItemEntity) {
        this.persistArchivedCopy(favouriteUserItemEntity);
        this.favouriteUserItemRepository.delete((Object)favouriteUserItemEntity);
    }

    private void persistArchivedCopy(FavouriteUserItemEntity favouriteUserItemEntity) {
        ArchivedFavouriteUserItemEntity archivedFavouriteSearchEntity = this.archivedFavouriteUserItemMapper.toArchiveEntity(favouriteUserItemEntity);
        this.archivedFavouriteUserItemRepository.saveAndFlush((Object)archivedFavouriteSearchEntity);
    }

    @Generated
    public DefaultFavouriteUserItemService(FavouriteUserItemRepository favouriteUserItemRepository, FavouriteUserItemMapper favouriteUserItemMapper, ArchivedFavouriteUserItemRepository archivedFavouriteUserItemRepository, ArchivedFavouriteUserItemMapper archivedFavouriteUserItemMapper) {
        this.favouriteUserItemRepository = favouriteUserItemRepository;
        this.favouriteUserItemMapper = favouriteUserItemMapper;
        this.archivedFavouriteUserItemRepository = archivedFavouriteUserItemRepository;
        this.archivedFavouriteUserItemMapper = archivedFavouriteUserItemMapper;
    }
}

