package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfileIdsUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfilesUserProfileDmDto;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface UserProfileDmClient {

    /**
     * Get the user profiles by ids
     *
     * @param ids to ids of the profiles to retrieve
     * @return the profiles found
     * @throws feign.FeignException.Unauthorized if the user is not authenticated
     * @throws feign.FeignException.InternalServerError if there is an internal server error
     */
    @PostMapping("/profiles-by-ids")
    UserProfilesUserProfileDmDto getProfilesByIds(
            @RequestBody UserProfileIdsUserProfileDmDto ids,
            @RequestParam long pageNumber,
            @RequestParam long pageSize);
}
