package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.ModerationApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPendingInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.ModerationService;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;
import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class ModerationController implements ModerationApi {
    private final ModerationService publishService;

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> searchLatestVersionPendingInstitutionalPages(
            InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto,
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction
    ) {
        OutputPageDto<OutputInstitutionalPageDto> pendingInstitutionalPages = publishService.searchLatestVersionPendingInstitutionalPages(
                inputSearchPendingInstitutionalPageDto,
                associationsToLoad,
                pageNumber,
                pageSize,
                sort,
                direction
        );

        return new ResponseEntity<>(pendingInstitutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getPendingInstitutionalPages(
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction
    ) {
        OutputPageDto<OutputInstitutionalPageDto> pendingInstitutionalPages = publishService.getPendingInstitutionalPages(
                associationsToLoad,
                pageNumber,
                pageSize,
                sort,
                direction
        );
        return new ResponseEntity<>(pendingInstitutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> getPendingInstitutionalPageById(UUID institutionalPageId) {
        OutputInstitutionalPageDto pendingInstitutionalPage = publishService.getPendingInstitutionalPageById(institutionalPageId);
        return new ResponseEntity<>(pendingInstitutionalPage, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> changeInstitutionalPageModerationStatus(
            UUID institutionalPageId,
            InputModerationStatusDto inputModerationStatusDto
    ) {
        OutputInstitutionalPageDto institutionalPageDto = publishService.changeInstitutionalPageModerationStatus(
                institutionalPageId,
                inputModerationStatusDto
        );
        return new ResponseEntity<>(institutionalPageDto, HttpStatus.OK);
    }

    @Override
    public OutputInstitutionalPageDto requestPublishInstitutionalPage(final UUID institutionalPageId) {
        return publishService.requestPublishInstitutionalPage(institutionalPageId);
    }
}
