package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for image metadata.
 */
@Schema(name = "InputImageMetadataDto", description = "Input DTO for image metadata")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InputImageMetadataDto {

    @Schema(description = "The name of the image", example = "institutional-page-logo.png")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String name;

    @Schema(description = "The description of the image", example = "Logo for the institutional page")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String description;
}