package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum ModerationStatusIPDmDto {
    APPROVED("Approved"),
    PENDING("Pending"),
    REJECTED("Rejected"),
    DRAFT("Draft");

    private final String label;

    ModerationStatusIPDmDto(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link ModerationStatusIPDmDto} object
     *
     * @param label the label to map to enum
     * @return {@link ModerationStatusIPDmDto} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static ModerationStatusIPDmDto ofLabel(String label) {
        for (ModerationStatusIPDmDto moderationStatus : ModerationStatusIPDmDto.values()) {
            if (moderationStatus.label.equalsIgnoreCase(label)) {
                return moderationStatus;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
