package com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;

/**
 * Interface defining methods for publishing events related to institutional page entities.
 * This includes events for creation, updates, and deletion of institutional pages.
 */
public interface InstitutionalPageProducer {

    /**
     * Publishes an event containing the created institutional page entity.
     *
     * @param institutionalPage the created institutional page
     */
    void publishCreateEvent(OutputInstitutionalPageDto institutionalPage);

    /**
     * Publishes an event containing the updated institutional page entity.
     *
     * @param institutionalPage the updated institutional page
     */
    void publishUpdateEvent(OutputInstitutionalPageDto institutionalPage);

    /**
     * Publishes an event containing the deleted institutional page entity.
     *
     * @param institutionalPage the deleted institutional page
     */
    void publishDeleteEvent(OutputInstitutionalPageDto institutionalPage);

}
