/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.InstitutionalPageApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputWorkspaceItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.InstitutionalPageService;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class InstitutionalPageController
implements InstitutionalPageApi {
    private final InstitutionalPageService institutionalPageService;

    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getAllInstitutionalPages(InstitutionalPageView view, boolean includePublishedAndNotMember, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto institutionalPages = this.institutionalPageService.getAllInstitutionalPages(view, includePublishedAndNotMember, associationsToLoad, pageNumber, pageSize, sort, direction);
        return new ResponseEntity((Object)institutionalPages, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<OutputInstitutionalPageDto> getInstitutionalPageById(UUID institutionalPageId, InstitutionalPageView view, boolean includePublishedAndNotMember) {
        OutputInstitutionalPageDto institutionalPage = this.institutionalPageService.getInstitutionalPageById(institutionalPageId, view, includePublishedAndNotMember);
        return new ResponseEntity((Object)institutionalPage, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<OutputInstitutionalPageDto> createInstitutionalPage(InputCreateInstitutionalPageDto institutionalPageDto, MultipartFile imageFile) {
        OutputInstitutionalPageDto createdInstitutionalPage = this.institutionalPageService.createInstitutionalPage(institutionalPageDto, imageFile);
        return new ResponseEntity((Object)createdInstitutionalPage, (HttpStatusCode)HttpStatus.CREATED);
    }

    public ResponseEntity<OutputInstitutionalPageDto> updateInstitutionalPage(UUID institutionalPageId, InputUpdateInstitutionalPageDto institutionalPageDto, MultipartFile imageFile) {
        OutputInstitutionalPageDto updatedInstitutionalPage = this.institutionalPageService.updateInstitutionalPage(institutionalPageId, institutionalPageDto, imageFile);
        return new ResponseEntity((Object)updatedInstitutionalPage, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<Void> deleteInstitutionalPage(UUID institutionalPageId) {
        this.institutionalPageService.deleteInstitutionalPage(institutionalPageId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> search(InstitutionalPageView view, InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto institutionalPages = this.institutionalPageService.search(view, inputSearchForMemberInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction);
        return new ResponseEntity((Object)institutionalPages, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> findInstitutionalPagesHierarchyByRootId(UUID rootInstitutionalPageId, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto institutionalPages = this.institutionalPageService.findInstitutionalPagesHierarchyByRootId(rootInstitutionalPageId, associationsToLoad, pageNumber, pageSize, sort, direction);
        return new ResponseEntity((Object)institutionalPages, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<List<OutputWorkspaceItemDto>> retrieveFolderContent(UUID institutionalPageId, int pageNumber, int pageSize) {
        List outputWorkspaceItemPage = this.institutionalPageService.retrieveFolderContent(institutionalPageId, pageNumber, pageSize);
        return new ResponseEntity((Object)outputWorkspaceItemPage, (HttpStatusCode)HttpStatus.OK);
    }

    public OutputInstitutionalPageDto requestModerationInstitutionalPage(UUID institutionalPageId) {
        return this.institutionalPageService.requestModerationInstitutionalPage(institutionalPageId);
    }

    public OutputInstitutionalPageDto requestPublicationInstitutionalPage(UUID institutionalPageId) {
        return this.institutionalPageService.requestPublicationInstitutionalPage(institutionalPageId);
    }

    public ResponseEntity<OutputRequestUpdateDto> requestUpdateInstitutionalPageById(UUID institutionalPageId) {
        OutputRequestUpdateDto outputRequestUpdateDto = this.institutionalPageService.requestUpdateInstitutionalPageById(institutionalPageId);
        return new ResponseEntity((Object)outputRequestUpdateDto, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<Void> cancelUpdateInstitutionalPageById(UUID institutionalPageId) {
        this.institutionalPageService.cancelUpdateInstitutionalPageById(institutionalPageId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public InstitutionalPageController(InstitutionalPageService institutionalPageService) {
        this.institutionalPageService = institutionalPageService;
    }
}

