/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputButtonDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCopyrightDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputImageMetadataDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRepositoriesDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="InputCreateInstitutionalPageDto", description="Input DTO for creating an institutionalPage")
public class InputCreateInstitutionalPageDto {
    @Schema(description="The name of the institutional page", example="Criterion")
    @NotNull(message="Required field")
    @Size(max=255, message="Field length must be between {min} and {max}")
    @Pattern(regexp="^[a-zA-Z0-9 _-]+$", message="Only letters, numbers, spaces, underscore (_) and dash (-) are allowed")
    private @NotNull(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") @Pattern(regexp="^[a-zA-Z0-9 _-]+$", message="Only letters, numbers, spaces, underscore (_) and dash (-) are allowed") String name;
    @Schema(description="The id of the parent institutional page", example="33333333-aaaa-1111-0000-000000000000")
    private UUID parentInstitutionalPageId;
    @NotNull(message="Required field")
    private @NotNull(message="Required field") Boolean published;
    @Schema(description="The category of the institutional page", allowableValues={"tool", "project"}, example="project")
    @Pattern(regexp="tool|project", message="Allowed values: 'tool', 'project'")
    @NotNull(message="Required field")
    private @Pattern(regexp="tool|project", message="Allowed values: 'tool', 'project'") @NotNull(message="Required field") String category;
    @Schema(description="The abstract of the institutional page", example="WP3, the Toolkit for Religious Studies (T-ReS), aims to improve the research experience.")
    @NotBlank(message="Required field")
    @Size(max=8000, message="Field length must be between {min} and {max}")
    private @NotBlank(message="Required field") @Size(max=8000, message="Field length must be between {min} and {max}") String abstractContent;
    @Schema(description="Copyright info for the institutional page")
    @NotNull(message="Required field")
    @Valid
    private @NotNull(message="Required field") @Valid InputCopyrightDto copyright;
    @Schema(description="The paragraphs related to the institutional page")
    private List<@Valid InputParagraphDto> paragraphs;
    @Schema(description="List of tags", example="[\"aramaic\",\"english\",\"italian\"]")
    private List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> tags;
    @Schema(description="List of languages", example="[\"English\",\"Italian\",\"German\"]")
    private List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> languages;
    @Schema(description="Image metadata for institutional page")
    @Valid
    private InputImageMetadataDto imageMetadata;
    @Schema(description="The user manual URL", example="https://www.usermanual.com")
    @Size(max=255, message="Field length must be between {min} and {max}")
    private @Size(max=255, message="Field length must be between {min} and {max}") String userManualUrl;
    @Schema(description="The FAQs page URL", example="https://www.faqs.com")
    @Size(max=255, message="Field length must be between {min} and {max}")
    private @Size(max=255, message="Field length must be between {min} and {max}") String faqsUrl;
    @Schema(description="The application version", example="v1.3.0")
    @Size(max=255, message="Field length must be between {min} and {max}")
    private @Size(max=255, message="Field length must be between {min} and {max}") String applicationVersion;
    @Schema(description="The application type", example="web application")
    @Size(max=255, message="Field length must be between {min} and {max}")
    private @Size(max=255, message="Field length must be between {min} and {max}") String applicationType;
    @Schema(description="The license name", example="MIT License")
    @Size(max=255, message="Field length must be between {min} and {max}")
    private @Size(max=255, message="Field length must be between {min} and {max}") String license;
    @Schema(description="The supported operating systems for the institutional page", example="Windows 10+, macOS 12+, Ubuntu 20.04+")
    @Size(max=800, message="Field length must be between {min} and {max}")
    private @Size(max=800, message="Field length must be between {min} and {max}") String supportedOs;
    @Schema(description="Input DTO of repository links for the institutional page")
    @Valid
    private InputRepositoriesDto repositories;
    @Schema(description="Additional arbitrary fields in key-value format", example="{\"developer\": \"John Doe\", \"releaseNotes\": \"Initial beta release\"}")
    private LinkedHashMap<@NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String, @NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String> additionalFields;
    @Schema(description="External links")
    private LinkedHashMap<String, String> externalLinks;
    @Schema(description="Buttons related to the institutional page")
    private List<@Valid InputButtonDto> buttons;

    @Generated
    public static InputCreateInstitutionalPageDtoBuilder builder() {
        return new InputCreateInstitutionalPageDtoBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UUID getParentInstitutionalPageId() {
        return this.parentInstitutionalPageId;
    }

    @Generated
    public Boolean getPublished() {
        return this.published;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getAbstractContent() {
        return this.abstractContent;
    }

    @Generated
    public InputCopyrightDto getCopyright() {
        return this.copyright;
    }

    @Generated
    public List<@Valid InputParagraphDto> getParagraphs() {
        return this.paragraphs;
    }

    @Generated
    public List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> getTags() {
        return this.tags;
    }

    @Generated
    public List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> getLanguages() {
        return this.languages;
    }

    @Generated
    public InputImageMetadataDto getImageMetadata() {
        return this.imageMetadata;
    }

    @Generated
    public String getUserManualUrl() {
        return this.userManualUrl;
    }

    @Generated
    public String getFaqsUrl() {
        return this.faqsUrl;
    }

    @Generated
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Generated
    public String getApplicationType() {
        return this.applicationType;
    }

    @Generated
    public String getLicense() {
        return this.license;
    }

    @Generated
    public String getSupportedOs() {
        return this.supportedOs;
    }

    @Generated
    public InputRepositoriesDto getRepositories() {
        return this.repositories;
    }

    @Generated
    public LinkedHashMap<@NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String, @NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Generated
    public LinkedHashMap<String, String> getExternalLinks() {
        return this.externalLinks;
    }

    @Generated
    public List<@Valid InputButtonDto> getButtons() {
        return this.buttons;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setParentInstitutionalPageId(UUID parentInstitutionalPageId) {
        this.parentInstitutionalPageId = parentInstitutionalPageId;
    }

    @Generated
    public void setPublished(Boolean published) {
        this.published = published;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setAbstractContent(String abstractContent) {
        this.abstractContent = abstractContent;
    }

    @Generated
    public void setCopyright(InputCopyrightDto copyright) {
        this.copyright = copyright;
    }

    @Generated
    public void setParagraphs(List<@Valid InputParagraphDto> paragraphs) {
        this.paragraphs = paragraphs;
    }

    @Generated
    public void setTags(List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setLanguages(List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> languages) {
        this.languages = languages;
    }

    @Generated
    public void setImageMetadata(InputImageMetadataDto imageMetadata) {
        this.imageMetadata = imageMetadata;
    }

    @Generated
    public void setUserManualUrl(String userManualUrl) {
        this.userManualUrl = userManualUrl;
    }

    @Generated
    public void setFaqsUrl(String faqsUrl) {
        this.faqsUrl = faqsUrl;
    }

    @Generated
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Generated
    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @Generated
    public void setSupportedOs(String supportedOs) {
        this.supportedOs = supportedOs;
    }

    @Generated
    public void setRepositories(InputRepositoriesDto repositories) {
        this.repositories = repositories;
    }

    @Generated
    public void setAdditionalFields(LinkedHashMap<@NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String, @NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    @Generated
    public void setExternalLinks(LinkedHashMap<String, String> externalLinks) {
        this.externalLinks = externalLinks;
    }

    @Generated
    public void setButtons(List<@Valid InputButtonDto> buttons) {
        this.buttons = buttons;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateInstitutionalPageDto)) {
            return false;
        }
        InputCreateInstitutionalPageDto other = (InputCreateInstitutionalPageDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$published = this.getPublished();
        Boolean other$published = other.getPublished();
        if (this$published == null ? other$published != null : !((Object)this$published).equals(other$published)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$parentInstitutionalPageId = this.getParentInstitutionalPageId();
        UUID other$parentInstitutionalPageId = other.getParentInstitutionalPageId();
        if (this$parentInstitutionalPageId == null ? other$parentInstitutionalPageId != null : !((Object)this$parentInstitutionalPageId).equals(other$parentInstitutionalPageId)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$abstractContent = this.getAbstractContent();
        String other$abstractContent = other.getAbstractContent();
        if (this$abstractContent == null ? other$abstractContent != null : !this$abstractContent.equals(other$abstractContent)) {
            return false;
        }
        InputCopyrightDto this$copyright = this.getCopyright();
        InputCopyrightDto other$copyright = other.getCopyright();
        if (this$copyright == null ? other$copyright != null : !this$copyright.equals(other$copyright)) {
            return false;
        }
        List this$paragraphs = this.getParagraphs();
        List other$paragraphs = other.getParagraphs();
        if (this$paragraphs == null ? other$paragraphs != null : !((Object)this$paragraphs).equals(other$paragraphs)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$languages = this.getLanguages();
        List other$languages = other.getLanguages();
        if (this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages)) {
            return false;
        }
        InputImageMetadataDto this$imageMetadata = this.getImageMetadata();
        InputImageMetadataDto other$imageMetadata = other.getImageMetadata();
        if (this$imageMetadata == null ? other$imageMetadata != null : !this$imageMetadata.equals(other$imageMetadata)) {
            return false;
        }
        String this$userManualUrl = this.getUserManualUrl();
        String other$userManualUrl = other.getUserManualUrl();
        if (this$userManualUrl == null ? other$userManualUrl != null : !this$userManualUrl.equals(other$userManualUrl)) {
            return false;
        }
        String this$faqsUrl = this.getFaqsUrl();
        String other$faqsUrl = other.getFaqsUrl();
        if (this$faqsUrl == null ? other$faqsUrl != null : !this$faqsUrl.equals(other$faqsUrl)) {
            return false;
        }
        String this$applicationVersion = this.getApplicationVersion();
        String other$applicationVersion = other.getApplicationVersion();
        if (this$applicationVersion == null ? other$applicationVersion != null : !this$applicationVersion.equals(other$applicationVersion)) {
            return false;
        }
        String this$applicationType = this.getApplicationType();
        String other$applicationType = other.getApplicationType();
        if (this$applicationType == null ? other$applicationType != null : !this$applicationType.equals(other$applicationType)) {
            return false;
        }
        String this$license = this.getLicense();
        String other$license = other.getLicense();
        if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
            return false;
        }
        String this$supportedOs = this.getSupportedOs();
        String other$supportedOs = other.getSupportedOs();
        if (this$supportedOs == null ? other$supportedOs != null : !this$supportedOs.equals(other$supportedOs)) {
            return false;
        }
        InputRepositoriesDto this$repositories = this.getRepositories();
        InputRepositoriesDto other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories)) {
            return false;
        }
        LinkedHashMap this$additionalFields = this.getAdditionalFields();
        LinkedHashMap other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        LinkedHashMap this$externalLinks = this.getExternalLinks();
        LinkedHashMap other$externalLinks = other.getExternalLinks();
        if (this$externalLinks == null ? other$externalLinks != null : !((Object)this$externalLinks).equals(other$externalLinks)) {
            return false;
        }
        List this$buttons = this.getButtons();
        List other$buttons = other.getButtons();
        return !(this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateInstitutionalPageDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $published = this.getPublished();
        result = result * 59 + ($published == null ? 43 : ((Object)$published).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $parentInstitutionalPageId = this.getParentInstitutionalPageId();
        result = result * 59 + ($parentInstitutionalPageId == null ? 43 : ((Object)$parentInstitutionalPageId).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $abstractContent = this.getAbstractContent();
        result = result * 59 + ($abstractContent == null ? 43 : $abstractContent.hashCode());
        InputCopyrightDto $copyright = this.getCopyright();
        result = result * 59 + ($copyright == null ? 43 : $copyright.hashCode());
        List $paragraphs = this.getParagraphs();
        result = result * 59 + ($paragraphs == null ? 43 : ((Object)$paragraphs).hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        InputImageMetadataDto $imageMetadata = this.getImageMetadata();
        result = result * 59 + ($imageMetadata == null ? 43 : $imageMetadata.hashCode());
        String $userManualUrl = this.getUserManualUrl();
        result = result * 59 + ($userManualUrl == null ? 43 : $userManualUrl.hashCode());
        String $faqsUrl = this.getFaqsUrl();
        result = result * 59 + ($faqsUrl == null ? 43 : $faqsUrl.hashCode());
        String $applicationVersion = this.getApplicationVersion();
        result = result * 59 + ($applicationVersion == null ? 43 : $applicationVersion.hashCode());
        String $applicationType = this.getApplicationType();
        result = result * 59 + ($applicationType == null ? 43 : $applicationType.hashCode());
        String $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : $license.hashCode());
        String $supportedOs = this.getSupportedOs();
        result = result * 59 + ($supportedOs == null ? 43 : $supportedOs.hashCode());
        InputRepositoriesDto $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
        LinkedHashMap $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        LinkedHashMap $externalLinks = this.getExternalLinks();
        result = result * 59 + ($externalLinks == null ? 43 : ((Object)$externalLinks).hashCode());
        List $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateInstitutionalPageDto(name=" + this.getName() + ", parentInstitutionalPageId=" + String.valueOf(this.getParentInstitutionalPageId()) + ", published=" + this.getPublished() + ", category=" + this.getCategory() + ", abstractContent=" + this.getAbstractContent() + ", copyright=" + String.valueOf(this.getCopyright()) + ", paragraphs=" + String.valueOf(this.getParagraphs()) + ", tags=" + String.valueOf(this.getTags()) + ", languages=" + String.valueOf(this.getLanguages()) + ", imageMetadata=" + String.valueOf(this.getImageMetadata()) + ", userManualUrl=" + this.getUserManualUrl() + ", faqsUrl=" + this.getFaqsUrl() + ", applicationVersion=" + this.getApplicationVersion() + ", applicationType=" + this.getApplicationType() + ", license=" + this.getLicense() + ", supportedOs=" + this.getSupportedOs() + ", repositories=" + String.valueOf(this.getRepositories()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ", externalLinks=" + String.valueOf(this.getExternalLinks()) + ", buttons=" + String.valueOf(this.getButtons()) + ")";
    }

    @Generated
    public InputCreateInstitutionalPageDto(String name, UUID parentInstitutionalPageId, Boolean published, String category, String abstractContent, InputCopyrightDto copyright, List<@Valid InputParagraphDto> paragraphs, List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> tags, List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> languages, InputImageMetadataDto imageMetadata, String userManualUrl, String faqsUrl, String applicationVersion, String applicationType, String license, String supportedOs, InputRepositoriesDto repositories, LinkedHashMap<@NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String, @NotBlank @Size(max=255, message="Field length must be between {min} and {max}") String> additionalFields, LinkedHashMap<String, String> externalLinks, List<@Valid InputButtonDto> buttons) {
        this.name = name;
        this.parentInstitutionalPageId = parentInstitutionalPageId;
        this.published = published;
        this.category = category;
        this.abstractContent = abstractContent;
        this.copyright = copyright;
        this.paragraphs = paragraphs;
        this.tags = tags;
        this.languages = languages;
        this.imageMetadata = imageMetadata;
        this.userManualUrl = userManualUrl;
        this.faqsUrl = faqsUrl;
        this.applicationVersion = applicationVersion;
        this.applicationType = applicationType;
        this.license = license;
        this.supportedOs = supportedOs;
        this.repositories = repositories;
        this.additionalFields = additionalFields;
        this.externalLinks = externalLinks;
        this.buttons = buttons;
    }

    @Generated
    public InputCreateInstitutionalPageDto() {
    }
}

