package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO of a join request or invitation related to a user.
 */
@Data
@Builder
@AllArgsConstructor
@Schema(name = "OutputPendingMemberRequestDto", description = "Output DTO of a join request or invitation")
public class OutputPendingMemberRequestDto {

    @Schema(description = "The institutional page")
    private OutputInstitutionalPageDto institutionalPage;

    private OutputUserProfileDto user;

    @Schema(description = "Indicate if the user should be added as wp leader", example = "false")
    private Boolean wpLeader;

    @Schema(description = "The invitation message", example = "Please join as a member")
    private String message;

}