/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchModerationInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.validation.ValidAssociationToLoad;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Set;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Moderation", description="The Moderation API: it provides endpoints to approve or reject and retrieve pending InstitutionalPages.")
@SecurityRequirement(name="BearerAuth")
public interface ModerationApi {
    @Operation(summary="Retrieves a paginated list of all InstitutionalPages under moderation (Pending or Rejected), matching the search criteria - moderator only", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/institutional-page/institutional-pages/moderation/search"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> searchModerationInstitutionalPages(@Valid @RequestBody InputSearchModerationInstitutionalPageDto var1, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var6);

    @Operation(summary="Retrieves a paginated list of all InstitutionalPages under moderation (Pending or Rejected) - moderator only")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/institutional-page/institutional-pages/moderation"}, produces={"application/json"})
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getModerationInstitutionalPages(@RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var5);

    @Operation(summary="Retrieves a InstitutionalPage under moderation (Pending or Rejected) by id - moderator only")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages/moderation/{institutionalPageId}"})
    public ResponseEntity<OutputInstitutionalPageDto> getModerationInstitutionalPageById(@PathVariable UUID var1);

    @Operation(summary="Approve or reject an institutional page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @PatchMapping(value={"/institutional-page/institutional-pages/moderation/{institutionalPageId}"})
    public ResponseEntity<OutputInstitutionalPageDto> changeInstitutionalPageModerationStatus(@PathVariable UUID var1, @Valid @RequestBody InputModerationStatusDto var2);
}

