package com.finconsgroup.itserr.marketplace.institutional_page.bs.validation;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.validation.validator.InputParagraphDtoValidator;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Constraint(validatedBy = {
        InputParagraphDtoValidator.class
})
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidInputDto {

    String message() default "Not valid input data";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}