package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserProfileDmDto {
    private UUID id;
    private String firstName;
    private String lastName;
    private String email;
    private String preferredUsername;
    private boolean userExists;
    private UUID userProfileFolderId;
    private String imageUrl;
    private CVUserProfileDmDto cv;
    private String orcid;
    private boolean openToCollaboration;
    private boolean showPublicEmail;
    private String personalWebsite;
    private String linkedinProfile;
    private String socialProfile;
    private String shortBio;
    private WorkingLocationUserProfileDmDto workingLocation;
    private String organizationAffiliation;
    private List<String> ssd;
    private List<ExpertiseDmDto> expertises;
    private List<Project> projects;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

    private String language;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Project {
        private UUID projectId;
        private String displayName;
        private String wp;
        private UUID rootProjectId;
        private String rootProjectDisplayName;
    }
}
