package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

@Schema(name = "InputModerationStatusDto", description = "Input DTO to approve/reject an institutional page")
@Data
@Builder
@AllArgsConstructor
public class InputModerationStatusDto {
    @Schema(description = "True if the institutional page is approved", example = "false")
    @NotNull
    private Boolean approved;

    @Schema(description = "Message of approval/rejection", example = "The institutional page is rejected because is not correct")
    private String message;
}
