/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.validation.ValidAssociationToLoad;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Set;
import java.util.UUID;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="Published institutional pages", description="Operations related to the published institutional pages")
public interface PublishedInstitutionalPageApi {
    @Operation(summary="Get all institutional pages published")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/institutional-page/institutional-pages/published"}, produces={"application/json"})
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getAllPublishedInstitutionalPages(@Schema(allowableValues={"all", "none", "parentInstitutionalPage", "wpLeads", "members", "childInstitutionalPages", "paragraphs"}) @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var5, @RequestParam(name="withPublications", defaultValue="true", required=false) boolean var6);

    @Operation(summary="Get institutional page published by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/institutional-page/institutional-pages/published/{institutionalPageId}"}, produces={"application/json"})
    public ResponseEntity<OutputInstitutionalPageDto> getPublishedInstitutionalPageById(@PathVariable UUID var1, @RequestParam(name="withPublications", defaultValue="true", required=false) boolean var2);

    @Operation(summary="Find all InstitutionalPages published matching the search criteria", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/institutional-page/institutional-pages/published/search"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> search(@Valid @RequestBody InputSearchPublishedInstitutionalPageDto var1, @Schema(allowableValues={"all", "none", "parentInstitutionalPage", "wpLeads", "members", "childInstitutionalPages", "paragraphs"}) @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var6, @RequestParam(name="withPublications", defaultValue="true", required=false) boolean var7);
}

