/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.InstitutionalPageApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InstitutionalPageController
implements InstitutionalPageApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageController.class);
    private final InstitutionalPageService institutionalPageService;

    public OutputInstitutionalPageDto createInstitutionalPage(InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages, inputCreateInstitutionalPageDto: {}", (Object)inputCreateInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.createInstitutionalPage(userId, inputCreateInstitutionalPageDto);
    }

    public Page<OutputInstitutionalPageDto> findAllInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.findAllInstitutionalPages(userId, associationsToLoad, (Pageable)pageable);
    }

    public Page<OutputInstitutionalPageDto> search(InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/search, inputSearchForMemberInstitutionalPageDto: {}", (Object)inputSearchForMemberInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.searchInstitutionalPages(userId, associationsToLoad, (Pageable)pageable, inputSearchForMemberInstitutionalPageDto);
    }

    public OutputInstitutionalPageDto findInstitutionalPageById(UUID institutionalPageId) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/{}", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.findInstitutionalPageById(userId, institutionalPageId);
    }

    public OutputInstitutionalPageDto updateInstitutionalPageById(UUID institutionalPageId, InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}, inputUpdateInstitutionalPageDto: {}", (Object)institutionalPageId, (Object)inputUpdateInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.updateInstitutionalPageById(userId, institutionalPageId, inputUpdateInstitutionalPageDto);
    }

    public OutputInstitutionalPageDto deleteInstitutionalPageById(UUID institutionalPageId) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.deleteInstitutionalPageById(userId, institutionalPageId);
    }

    public Page<OutputInstitutionalPageDto> findInstitutionalPagesHierarchyByRootId(UUID rootInstitutionalPageId, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("GET /api/v1/dm//institutional-page/institutional-pages/{institutionalPageId}/hierarchy");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.findInstitutionalPagesHierarchyByRootId(userId, associationsToLoad, (Pageable)pageable, rootInstitutionalPageId);
    }

    public OutputInstitutionalPageDto updateFolderId(UUID institutionalPageId, UUID newFolderId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/folders/{}", (Object)institutionalPageId, (Object)newFolderId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.updateFolderId(userId, institutionalPageId, newFolderId);
    }

    @Generated
    public InstitutionalPageController(InstitutionalPageService institutionalPageService) {
        this.institutionalPageService = institutionalPageService;
    }
}

