/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.MemberRequestsAlreadyExistException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.MemberRequestsNotFoundException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.MemberRequestRepository;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MemberRequestHelper {
    private final MemberRequestRepository memberRequestRepository;

    public void deleteMemberRequestsForInstitutionalPage(UUID institutionalPageId) {
        this.memberRequestRepository.deleteAllByInstitutionalPageId(institutionalPageId);
    }

    public List<MemberRequestEntity> retrieveMemberRequests(UUID institutionalPageId, List<UUID> userIds) {
        return this.memberRequestRepository.findAllByInstitutionalPageIdAndUserIdIn(institutionalPageId, userIds);
    }

    public List<MemberRequestEntity> retrieveInvitations(UUID institutionalPageId, List<UUID> invitedUserIds) {
        return this.memberRequestRepository.findAllByInstitutionalPageIdAndUserIdInAndRequestType(institutionalPageId, invitedUserIds, MemberRequestType.INVITATION);
    }

    public MemberRequestEntity retrieveInvitationOrThrow(UUID institutionalPageId, UUID invitedUserId) {
        return (MemberRequestEntity)this.retrieveInvitation(institutionalPageId, invitedUserId).orElseThrow(() -> new MemberRequestsNotFoundException(institutionalPageId, Set.of(invitedUserId)));
    }

    public Optional<MemberRequestEntity> retrieveInvitation(UUID institutionalPageId, UUID invitedUserId) {
        return this.memberRequestRepository.findByInstitutionalPageIdAndUserIdAndRequestType(institutionalPageId, invitedUserId, MemberRequestType.INVITATION);
    }

    public MemberRequestEntity retrieveJoinRequestOrThrow(UUID institutionalPageId, UUID userId) {
        return (MemberRequestEntity)this.retrieveJoinRequest(institutionalPageId, userId).orElseThrow(() -> new MemberRequestsNotFoundException(institutionalPageId, Set.of(userId)));
    }

    public Optional<MemberRequestEntity> retrieveJoinRequest(UUID institutionalPageId, UUID userId) {
        return this.memberRequestRepository.findByInstitutionalPageIdAndUserIdAndRequestType(institutionalPageId, userId, MemberRequestType.JOIN_REQUEST);
    }

    public List<MemberRequestEntity> retrieveAllJoinRequestsByUserIdsOrThrow(UUID institutionalPageId, List<UUID> userIds) {
        List joinRequestEntities = this.retrieveMemberRequests(institutionalPageId, userIds, MemberRequestType.JOIN_REQUEST);
        MemberRequestHelper.verifyAllMemberRequestsFoundOrThrow((UUID)institutionalPageId, (List)joinRequestEntities, userIds);
        return joinRequestEntities;
    }

    public void verifyInvitationsNotAlreadyExistOrThrow(UUID institutionalPageId, List<UUID> userIds) {
        this.verifyMemberRequestsNotAlreadyExistOrThrow(institutionalPageId, userIds, MemberRequestType.INVITATION);
    }

    public void verifyJoinRequestsNotAlreadyExistOrThrow(UUID institutionalPageId, List<UUID> userIds) {
        this.verifyMemberRequestsNotAlreadyExistOrThrow(institutionalPageId, userIds, MemberRequestType.JOIN_REQUEST);
    }

    private void verifyMemberRequestsNotAlreadyExistOrThrow(UUID institutionalPageId, List<UUID> userIds, MemberRequestType memberRequestType) {
        List<UUID> userIdsWIthExistingMemberRequests = this.retrieveMemberRequests(institutionalPageId, userIds, memberRequestType).stream().map(memberRequestEntity -> memberRequestEntity.getUserId()).toList();
        if (!userIdsWIthExistingMemberRequests.isEmpty()) {
            throw new MemberRequestsAlreadyExistException(institutionalPageId, userIdsWIthExistingMemberRequests);
        }
    }

    private List<MemberRequestEntity> retrieveMemberRequests(UUID institutionalPageId, List<UUID> userIds, MemberRequestType memberRequestType) {
        return this.memberRequestRepository.findAllByInstitutionalPageIdAndUserIdInAndRequestType(institutionalPageId, userIds, memberRequestType);
    }

    private static void verifyAllMemberRequestsFoundOrThrow(UUID institutionalPageId, List<MemberRequestEntity> foundRequestEntities, List<UUID> requestedUserIds) {
        Set foundUserIds = foundRequestEntities.stream().map(MemberRequestEntity::getUserId).collect(Collectors.toSet());
        HashSet<UUID> notFoundUserIds = new HashSet<UUID>(requestedUserIds);
        notFoundUserIds.removeAll(foundUserIds);
        if (!notFoundUserIds.isEmpty()) {
            throw new MemberRequestsNotFoundException(institutionalPageId, notFoundUserIds);
        }
    }

    @Generated
    public MemberRequestHelper(MemberRequestRepository memberRequestRepository) {
        this.memberRequestRepository = memberRequestRepository;
    }
}

