package com.finconsgroup.itserr.marketplace.institutionalpage.dm.model;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import org.springframework.data.domain.Pageable;

import java.util.List;


@Data
@Builder
@AllArgsConstructor
public class MembersInHierarchyModel {

    // list containing all the members entities (with duplicates)
    // belonging to the hierarchy of a given root institutional page
    // for the required page
    private List<MemberEntity> members;

    // the pagination information
    private Pageable pageable;

    // total number of members in the hierarchy
    // this number is not related to the 'members' list
    private long totalElements;

}
