/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.EntityBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedInstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ArchivedEntityMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.ArchivedInstitutionalPageRepository;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.ArchivedMemberRequestRepository;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ArchiveHelper {
    private final ArchivedInstitutionalPageRepository archivedInstitutionalPageRepository;
    private final ArchivedMemberRequestRepository archivedMemberRequestRepository;
    private final ArchivedEntityMapper archivedEntityMapper;
    private final EntityBuilder entityBuilder;

    public void persistArchivedCopy(InstitutionalPageEntity institutionalPageEntity) {
        ArchivedInstitutionalPageEntity archivedInstitutionalPageEntity = this.entityBuilder.buildArchivedEntity(institutionalPageEntity);
        this.archivedInstitutionalPageRepository.saveAndFlush((Object)archivedInstitutionalPageEntity);
    }

    public void persistArchivedCopy(MemberRequestEntity requestEntity, MemberRequestStatus requestStatus, String message) {
        this.persistArchivedCopy(List.of(requestEntity), requestStatus, message);
    }

    public void persistArchivedCopy(List<MemberRequestEntity> requestEntities, MemberRequestStatus requestStatus, String message) {
        List archivedRequestEntities = StringUtils.isNotBlank((CharSequence)message) ? this.archivedEntityMapper.toArchiveEntityList(requestEntities, requestStatus, message) : this.archivedEntityMapper.toArchiveEntityList(requestEntities, requestStatus);
        this.archivedMemberRequestRepository.saveAllAndFlush((Iterable)archivedRequestEntities);
    }

    @Generated
    public ArchiveHelper(ArchivedInstitutionalPageRepository archivedInstitutionalPageRepository, ArchivedMemberRequestRepository archivedMemberRequestRepository, ArchivedEntityMapper archivedEntityMapper, EntityBuilder entityBuilder) {
        this.archivedInstitutionalPageRepository = archivedInstitutionalPageRepository;
        this.archivedMemberRequestRepository = archivedMemberRequestRepository;
        this.archivedEntityMapper = archivedEntityMapper;
        this.entityBuilder = entityBuilder;
    }
}

