package com.finconsgroup.itserr.marketplace.institutionalpage.dm.converter;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.InstitutionalPageView;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class InstitutionalPageViewJsonConverter
        implements Converter<String, InstitutionalPageView> {

    @Override
    public InstitutionalPageView convert(String source) {
        if (source == null || source.isBlank()) {
            throw new IllegalArgumentException("institutionalPageView must not be blank");
        }
        return InstitutionalPageView.ofLabel(source);
    }
}