/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.core.web.exception.MissingRoleException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.InstitutionalPageNotFoundException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.NotInstitutionalPageMemberException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.NotInstitutionalPageWPLeaderException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.UsersAlreadyMemberException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.MembersInHierarchyModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.MemberRepository;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class MemberHelper {
    @Value(value="${institutional-page.dm.security.audience}")
    private String securityAudience;
    private final InstitutionalPageHelper institutionalPageHelper;
    private final MemberRepository memberRepository;

    public void deleteRegularMembersFromDescendants(UUID userId, UUID rootInstitutionalPageId, List<UUID> targetUserIds) {
        List institutionalPages = this.institutionalPageHelper.retrieveAllOriginalInHierarchyForMemberByRootId(userId, Pageable.unpaged(), rootInstitutionalPageId).getContent();
        LinkedList<InstitutionalPageEntity> updatedInstitutionalPages = new LinkedList<InstitutionalPageEntity>();
        for (InstitutionalPageEntity institutionalPage : institutionalPages) {
            boolean removed = institutionalPage.getMembers().removeIf(member -> !member.isWpLead() && targetUserIds.contains(member.getMemberId()));
            if (!removed) continue;
            updatedInstitutionalPages.add(institutionalPage);
        }
        this.institutionalPageHelper.saveAll(userId, updatedInstitutionalPages);
    }

    public void verifyIPModeratorOrWpLeaderOrThrow(UUID userId, UUID institutionalPageId) {
        if (this.hasIPModerateRole()) {
            return;
        }
        this.verifyWpLeaderOrThrow(userId, institutionalPageId);
    }

    public void verifyIPModeratorOrThrow() {
        if (!this.hasIPModerateRole()) {
            throw new MissingRoleException(JwtTokenHolder.getUserIdOrThrow(), Set.of("Member"));
        }
    }

    public boolean hasIPModerateRole() {
        return JwtTokenHolder.getRoles((String)this.securityAudience).contains("Member");
    }

    public void verifyWpLeaderOrThrow(UUID userId, UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPage = this.institutionalPageHelper.retrieveInstitutionalPage(institutionalPageId);
        if (!this.isWpLeader(userId, institutionalPage)) {
            if (this.isRegularMember(userId, institutionalPage) || institutionalPage.isPublished()) {
                throw new NotInstitutionalPageWPLeaderException(userId, institutionalPageId);
            }
            throw new InstitutionalPageNotFoundException(institutionalPageId);
        }
    }

    public boolean isWpLeader(UUID userId, InstitutionalPageEntity institutionalPage) {
        UUID rootId = InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
        return this.memberRepository.existsByMemberIdAndInstitutionalPageIdAndWpLead(userId, rootId, true);
    }

    public boolean isMember(UUID userId, InstitutionalPageEntity institutionalPage) {
        return this.isRegularMember(userId, institutionalPage) || this.isWpLeader(userId, institutionalPage);
    }

    public boolean isRegularMember(UUID userId, InstitutionalPageEntity institutionalPage) {
        return this.memberRepository.existsByMemberIdAndInstitutionalPageIdAndWpLead(userId, institutionalPage.getId(), false);
    }

    public void verifyMemberOrThrow(UUID userId, UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPage = this.institutionalPageHelper.retrieveInstitutionalPage(institutionalPageId);
        if (!this.isMember(userId, institutionalPage)) {
            if (institutionalPage.isPublished()) {
                throw new NotInstitutionalPageMemberException(userId, institutionalPageId);
            }
            throw new InstitutionalPageNotFoundException(institutionalPageId);
        }
    }

    public void verifyNotAlreadyMemberOrThrow(UUID userId, UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPage = this.institutionalPageHelper.retrieveInstitutionalPage(institutionalPageId);
        if (this.isMember(userId, institutionalPage)) {
            throw new UsersAlreadyMemberException(institutionalPageId, List.of(userId));
        }
    }

    public void verifyNotAlreadyMembersOrThrow(List<UUID> userIds, UUID institutionalPageId) {
        List<UUID> alreadyMembers = this.retrieveMembersByInstitutionalPageAndMemberIds(institutionalPageId, userIds).stream().map(memberEntity -> memberEntity.getMemberId()).toList();
        if (!alreadyMembers.isEmpty()) {
            throw new UsersAlreadyMemberException(institutionalPageId, alreadyMembers);
        }
    }

    public MembersInHierarchyModel findUsersByRootId(Pageable pageable, UUID rootInstitutionalPageId) {
        Page userIdPage = this.memberRepository.findDistinctMemberIdsOrderedByWpLead(pageable, rootInstitutionalPageId).map(membershipModel -> membershipModel.getMemberId());
        List members = this.memberRepository.findAllMembersByRootIdAndMemberIds(rootInstitutionalPageId, userIdPage.getContent());
        return MembersInHierarchyModel.builder().members(members).pageable(pageable).totalElements(userIdPage.getTotalElements()).build();
    }

    private List<MemberEntity> retrieveWpLeadsByInstitutionalPageAndMemberIds(UUID institutionalPageId, List<UUID> memberIds) {
        UUID rootId = this.institutionalPageHelper.retrieveRootInstitutionalPageId(institutionalPageId);
        return this.memberRepository.findAllByInstitutionalPageIdAndMemberIdInAndWpLead(rootId, memberIds, true);
    }

    private List<MemberEntity> retrieveMembersByInstitutionalPageAndMemberIds(UUID institutionalPageId, List<UUID> memberIds) {
        List memberEntities = this.retrieveWpLeadsByInstitutionalPageAndMemberIds(institutionalPageId, memberIds);
        memberEntities.addAll(this.memberRepository.findAllByInstitutionalPageIdAndMemberIdInAndWpLead(institutionalPageId, memberIds, false));
        return memberEntities;
    }

    public List<MemberEntity> retrieveWPLeadersByInstitutionalPages(List<InstitutionalPageEntity> institutionalPages) {
        List<UUID> rootIds = institutionalPages.stream().map(ip -> InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)ip)).toList();
        return this.memberRepository.findAllByInstitutionalPageIdInAndWpLead(rootIds, true);
    }

    public List<MemberEntity> retrieveRegularMembersByInstitutionalPages(List<InstitutionalPageEntity> institutionalPages) {
        List<UUID> originalIds = institutionalPages.stream().map(ip -> InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)ip)).toList();
        return this.memberRepository.findAllByInstitutionalPageIdInAndWpLead(originalIds, false);
    }

    @Generated
    public MemberHelper(InstitutionalPageHelper institutionalPageHelper, MemberRepository memberRepository) {
        this.institutionalPageHelper = institutionalPageHelper;
        this.memberRepository = memberRepository;
    }
}

