package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedInstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedMemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedMemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.ButtonModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-01-28T11:33:43+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ArchivedEntityMapperImpl implements ArchivedEntityMapper {

    @Override
    public ArchivedInstitutionalPageEntity toArchiveEntity(InstitutionalPageEntity src) {
        if ( src == null ) {
            return null;
        }

        ArchivedInstitutionalPageEntity.ArchivedInstitutionalPageEntityBuilder<?, ?> archivedInstitutionalPageEntity = ArchivedInstitutionalPageEntity.builder();

        archivedInstitutionalPageEntity.id( src.getId() );
        archivedInstitutionalPageEntity.name( src.getName() );
        archivedInstitutionalPageEntity.parentInstitutionalPageId( src.getParentInstitutionalPageId() );
        List<UUID> list = src.getAncestorInstitutionalPageIds();
        if ( list != null ) {
            archivedInstitutionalPageEntity.ancestorInstitutionalPageIds( new ArrayList<UUID>( list ) );
        }
        archivedInstitutionalPageEntity.workspaceFolderId( src.getWorkspaceFolderId() );
        archivedInstitutionalPageEntity.members( memberEntityListToArchivedMemberEntityList( src.getMembers() ) );
        archivedInstitutionalPageEntity.paragraphs( paragraphEntityListToArchivedParagraphEntityList( src.getParagraphs() ) );
        archivedInstitutionalPageEntity.category( src.getCategory() );
        archivedInstitutionalPageEntity.published( src.isPublished() );
        archivedInstitutionalPageEntity.toDelete( src.isToDelete() );
        archivedInstitutionalPageEntity.moderationStatus( src.getModerationStatus() );
        archivedInstitutionalPageEntity.publicationTime( src.getPublicationTime() );
        archivedInstitutionalPageEntity.rejectionMessage( src.getRejectionMessage() );
        archivedInstitutionalPageEntity.originalInstitutionalPageId( src.getOriginalInstitutionalPageId() );
        archivedInstitutionalPageEntity.updatedInstitutionalPageId( src.getUpdatedInstitutionalPageId() );
        archivedInstitutionalPageEntity.abstractContent( src.getAbstractContent() );
        archivedInstitutionalPageEntity.copyrightText( src.getCopyrightText() );
        archivedInstitutionalPageEntity.copyrightYear( src.getCopyrightYear() );
        archivedInstitutionalPageEntity.maintainer( src.getMaintainer() );
        List<String> list3 = src.getTags();
        if ( list3 != null ) {
            archivedInstitutionalPageEntity.tags( new ArrayList<String>( list3 ) );
        }
        List<String> list4 = src.getLanguages();
        if ( list4 != null ) {
            archivedInstitutionalPageEntity.languages( new ArrayList<String>( list4 ) );
        }
        archivedInstitutionalPageEntity.imageUrl( src.getImageUrl() );
        archivedInstitutionalPageEntity.userManualUrl( src.getUserManualUrl() );
        archivedInstitutionalPageEntity.faqsUrl( src.getFaqsUrl() );
        archivedInstitutionalPageEntity.applicationVersion( src.getApplicationVersion() );
        archivedInstitutionalPageEntity.applicationType( src.getApplicationType() );
        archivedInstitutionalPageEntity.license( src.getLicense() );
        archivedInstitutionalPageEntity.supportedOs( src.getSupportedOs() );
        archivedInstitutionalPageEntity.repoName( src.getRepoName() );
        archivedInstitutionalPageEntity.website( src.getWebsite() );
        LinkedHashMap<String, String> linkedHashMap = src.getAdditionalFields();
        if ( linkedHashMap != null ) {
            archivedInstitutionalPageEntity.additionalFields( new LinkedHashMap<String, String>( linkedHashMap ) );
        }
        LinkedHashMap<String, String> linkedHashMap1 = src.getExternalLinks();
        if ( linkedHashMap1 != null ) {
            archivedInstitutionalPageEntity.externalLinks( new LinkedHashMap<String, String>( linkedHashMap1 ) );
        }
        List<ButtonModel> list5 = src.getButtons();
        if ( list5 != null ) {
            archivedInstitutionalPageEntity.buttons( new ArrayList<ButtonModel>( list5 ) );
        }
        archivedInstitutionalPageEntity.updateLockedBy( src.getUpdateLockedBy() );
        archivedInstitutionalPageEntity.lastModifiedBy( src.getLastModifiedBy() );
        archivedInstitutionalPageEntity.creationTime( src.getCreationTime() );
        archivedInstitutionalPageEntity.updateTime( src.getUpdateTime() );

        return archivedInstitutionalPageEntity.build();
    }

    @Override
    public ArchivedMemberEntity toArchiveEntity(MemberEntity src) {
        if ( src == null ) {
            return null;
        }

        ArchivedMemberEntity.ArchivedMemberEntityBuilder<?, ?> archivedMemberEntity = ArchivedMemberEntity.builder();

        archivedMemberEntity.id( src.getId() );
        archivedMemberEntity.memberId( src.getMemberId() );
        archivedMemberEntity.wpLead( src.isWpLead() );
        archivedMemberEntity.creationTime( src.getCreationTime() );
        archivedMemberEntity.updateTime( src.getUpdateTime() );

        return archivedMemberEntity.build();
    }

    @Override
    public ArchivedParagraphEntity toArchiveEntity(ParagraphEntity src) {
        if ( src == null ) {
            return null;
        }

        ArchivedParagraphEntity.ArchivedParagraphEntityBuilder<?, ?> archivedParagraphEntity = ArchivedParagraphEntity.builder();

        archivedParagraphEntity.id( src.getId() );
        archivedParagraphEntity.title( src.getTitle() );
        archivedParagraphEntity.content( src.getContent() );
        archivedParagraphEntity.imageUrl( src.getImageUrl() );
        archivedParagraphEntity.resourceUrl( src.getResourceUrl() );
        List<String> list = src.getLabels();
        if ( list != null ) {
            archivedParagraphEntity.labels( new ArrayList<String>( list ) );
        }
        archivedParagraphEntity.creationTime( src.getCreationTime() );
        archivedParagraphEntity.updateTime( src.getUpdateTime() );

        return archivedParagraphEntity.build();
    }

    @Override
    public ArchivedMemberRequestEntity toArchiveEntity(MemberRequestEntity src, MemberRequestStatus requestStatus, String message) {
        if ( src == null && requestStatus == null && message == null ) {
            return null;
        }

        ArchivedMemberRequestEntity.ArchivedMemberRequestEntityBuilder<?, ?> archivedMemberRequestEntity = ArchivedMemberRequestEntity.builder();

        if ( src != null ) {
            archivedMemberRequestEntity.id( src.getId() );
            archivedMemberRequestEntity.userId( src.getUserId() );
            archivedMemberRequestEntity.institutionalPageId( src.getInstitutionalPageId() );
            archivedMemberRequestEntity.requestType( src.getRequestType() );
            archivedMemberRequestEntity.wpLeader( src.isWpLeader() );
            archivedMemberRequestEntity.creationTime( src.getCreationTime() );
            archivedMemberRequestEntity.updateTime( src.getUpdateTime() );
        }
        archivedMemberRequestEntity.requestStatus( requestStatus );
        archivedMemberRequestEntity.message( message );

        return archivedMemberRequestEntity.build();
    }

    @Override
    public ArchivedMemberRequestEntity toArchiveEntity(MemberRequestEntity src, MemberRequestStatus requestStatus) {
        if ( src == null && requestStatus == null ) {
            return null;
        }

        ArchivedMemberRequestEntity.ArchivedMemberRequestEntityBuilder<?, ?> archivedMemberRequestEntity = ArchivedMemberRequestEntity.builder();

        if ( src != null ) {
            archivedMemberRequestEntity.id( src.getId() );
            archivedMemberRequestEntity.userId( src.getUserId() );
            archivedMemberRequestEntity.institutionalPageId( src.getInstitutionalPageId() );
            archivedMemberRequestEntity.requestType( src.getRequestType() );
            archivedMemberRequestEntity.wpLeader( src.isWpLeader() );
            archivedMemberRequestEntity.message( src.getMessage() );
            archivedMemberRequestEntity.creationTime( src.getCreationTime() );
            archivedMemberRequestEntity.updateTime( src.getUpdateTime() );
        }
        archivedMemberRequestEntity.requestStatus( requestStatus );

        return archivedMemberRequestEntity.build();
    }

    protected List<ArchivedMemberEntity> memberEntityListToArchivedMemberEntityList(List<MemberEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedMemberEntity> list1 = new ArrayList<ArchivedMemberEntity>( list.size() );
        for ( MemberEntity memberEntity : list ) {
            list1.add( toArchiveEntity( memberEntity ) );
        }

        return list1;
    }

    protected List<ArchivedParagraphEntity> paragraphEntityListToArchivedParagraphEntityList(List<ParagraphEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedParagraphEntity> list1 = new ArrayList<ArchivedParagraphEntity>( list.size() );
        for ( ParagraphEntity paragraphEntity : list ) {
            list1.add( toArchiveEntity( paragraphEntity ) );
        }

        return list1;
    }
}
